/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core;

import org.projectusus.bugprison.core.BugMetrics;
import org.projectusus.bugprison.core.IAverageMetrics;
import org.projectusus.bugprison.core.texts.BugPrisonTexts;

public class AverageBugMetrics
implements IAverageMetrics {
    private int numberOfBugs;
    final BugMetrics bugMetrics = new BugMetrics();

    public void addBugMetrics(BugMetrics metrics) {
        ++this.numberOfBugs;
        this.bugMetrics.add(metrics);
    }

    @Override
    public double getAverageCyclomaticComplexity() {
        return this.computAverage(this.bugMetrics.getCyclomaticComplexity());
    }

    @Override
    public double getAverageMethodLength() {
        return this.computAverage(this.bugMetrics.getMethodLength());
    }

    @Override
    public double getAverageNumberOfMethodsInClass() {
        return this.computAverage(this.bugMetrics.getNumberOfMethods());
    }

    private double computAverage(int value) {
        if (this.numberOfBugs == 0) {
            return Double.NaN;
        }
        return value / this.numberOfBugs;
    }

    public void addAverageBugMetrics(AverageBugMetrics averageMetrics) {
        this.numberOfBugs += averageMetrics.getNumberOfBugs();
        this.bugMetrics.add(averageMetrics.getBugMetrics());
    }

    public BugMetrics getBugMetrics() {
        return this.bugMetrics;
    }

    public int getNumberOfBugs() {
        return this.numberOfBugs;
    }

    @Override
    public String getName() {
        return BugPrisonTexts.AverageBugMetrics_allBugs;
    }
}

