/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.sqi.jdtdriver;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.adapter.StatusCollector;

public class StatusCollectorTest {
    @Test
    public void finishDoesNothingWithoutErrorsCollected() throws CoreException {
        new StatusCollector().finish();
    }

    @Test(expected=CoreException.class)
    public void finishThrowsCollectedException() throws CoreException {
        StatusCollector statusCollector = new StatusCollector();
        statusCollector.add(new Exception());
        statusCollector.finish();
    }

    @Test(expected=CoreException.class)
    public void finishThrowsCollectedCoreException() throws CoreException {
        StatusCollector statusCollector = new StatusCollector();
        statusCollector.add(new CoreException(Status.OK_STATUS));
        statusCollector.finish();
    }

    @Test
    public void multipleExceptionsAppearInMultiStatus() {
        StatusCollector statusCollector = new StatusCollector();
        statusCollector.add(new Exception());
        statusCollector.add(new Exception());
        try {
            statusCollector.finish();
        }
        catch (CoreException cex) {
            IStatus status = cex.getStatus();
            Assert.assertTrue((boolean)status.isMultiStatus());
            Assert.assertEquals((long)2L, (long)((MultiStatus)status).getChildren().length);
        }
    }
}

