/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import org.eclipse.core.runtime.Platform;

public enum TracingOption {
    SQI("[SQI]"),
    RESOURCE_CHANGES("[ResCh]");

    private final String tracePrefix;
    private final boolean tracing;

    private TracingOption(String tracePrefix) {
        this.tracePrefix = tracePrefix;
        this.tracing = this.isTracing();
    }

    public void trace(String content) {
        if (this.tracing) {
            System.out.println(String.valueOf(this.tracePrefix) + " " + content);
        }
    }

    public void trace(Throwable thr) {
        if (this.tracing) {
            this.trace(thr.getMessage());
            thr.printStackTrace();
        }
    }

    private boolean isTracing() {
        String option = "org.projectusus.adapter/" + this.name();
        String value = Platform.getDebugOption((String)option);
        return value != null && Boolean.parseBoolean(value);
    }
}

