/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class StatusCollector {
    public static final String jdtDriver_errors = "Errors occurred during code proportions computation.";
    private final Set<IStatus> errors = new HashSet<IStatus>();

    public void add(Throwable thr) {
        if (thr instanceof CoreException) {
            this.errors.add(((CoreException)thr).getStatus());
        } else {
            this.addNewStatusFrom(thr);
        }
    }

    public void finish() throws CoreException {
        if (!this.errors.isEmpty()) {
            throw new CoreException(this.createMultiStatus());
        }
    }

    private void addNewStatusFrom(Throwable thr) {
        String msg = thr.getMessage() == null ? "[No details.]" : thr.getMessage();
        this.errors.add((IStatus)new Status(4, "org.projectusus.core", msg, thr));
    }

    private IStatus createMultiStatus() {
        MultiStatus result = new MultiStatus("org.projectusus.core", 4, jdtDriver_errors, null);
        for (IStatus error : this.errors) {
            result.add(error);
        }
        return result;
    }
}

