/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.projectusus.adapter.CodeProportionsComputerJob;
import org.projectusus.adapter.DeltaCodeProportionComputationTarget;
import org.projectusus.adapter.ICodeProportionComputationTarget;
import org.projectusus.adapter.WorkspaceCodeProportionComputationTarget;
import org.projectusus.core.UsusCorePlugin;
import org.projectusus.core.statistics.UsusModelProvider;

public class RunComputationOnResourceChange
implements IResourceChangeListener {
    private static final List<IResourceDelta> collectedDeltas = new ArrayList<IResourceDelta>();
    private static boolean cockpitIsVisible = false;

    public static void cockpitIsVisible() {
        cockpitIsVisible = true;
        RunComputationOnResourceChange.runComputationJobOnCollectedDeltas();
    }

    public static void cockpitIsInvisible() {
        cockpitIsVisible = false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.collectDelta(event);
        RunComputationOnResourceChange.runComputationJobOnCollectedDeltas();
    }

    private void collectDelta(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            collectedDeltas.add(delta);
        }
    }

    private static void runComputationJobOnCollectedDeltas() {
        if (!cockpitIsVisible) {
            return;
        }
        try {
            RunComputationOnResourceChange.runComputationJob(collectedDeltas);
            collectedDeltas.clear();
        }
        catch (CoreException cex) {
            RunComputationOnResourceChange.log(cex.getStatus());
        }
    }

    private static void runComputationJob(List<IResourceDelta> deltas) throws CoreException {
        if (deltas.isEmpty()) {
            return;
        }
        ICodeProportionComputationTarget target = null;
        target = UsusModelProvider.ususModel().needsFullRecompute() ? new WorkspaceCodeProportionComputationTarget() : new DeltaCodeProportionComputationTarget(deltas);
        if (target.isNotEmpty()) {
            new CodeProportionsComputerJob(target).schedule();
        }
    }

    private static void log(IStatus status) {
        UsusCorePlugin.getDefault().getLog().log(status);
    }
}

