/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.projectusus.adapter.ICodeProportionComputationTarget;
import org.projectusus.core.project.FindUsusProjects;

class ProjectCodeProportionComputationTarget
implements ICodeProportionComputationTarget {
    private final Iterable<IProject> projects;

    public ProjectCodeProportionComputationTarget(IProject ... projects) {
        this(Arrays.asList(projects));
    }

    public ProjectCodeProportionComputationTarget(Iterable<IProject> projects) {
        this.projects = projects;
    }

    @Override
    public Collection<IProject> getProjects() {
        return this.findUsusProjects().compute();
    }

    @Override
    public Collection<IProject> getRemovedProjects() {
        return this.findUsusProjects().computeOpposite();
    }

    private FindUsusProjects findUsusProjects() {
        return new FindUsusProjects(this.projects);
    }

    @Override
    public Collection<IFile> getFiles(IProject project) throws CoreException {
        return this.collectFiles(project);
    }

    @Override
    public Collection<IFile> getRemovedFiles(IProject project) throws CoreException {
        return Collections.emptyList();
    }

    private Collection<IFile> collectFiles(IProject project) throws CoreException {
        HashMap<String, IFile> files = new HashMap<String, IFile>();
        List<IResource> resources = this.collectResources((IContainer)project);
        for (IResource resource : resources) {
            if (!(resource instanceof IFile)) continue;
            this.addFile((IFile)resource, files);
        }
        return files.values();
    }

    private List<IResource> collectResources(IContainer container) throws CoreException {
        IResource[] children;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] iResourceArray = children = container.members();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            resources.add(child);
            if (child instanceof IContainer) {
                resources.addAll(this.collectResources((IContainer)child));
            }
            ++n2;
        }
        return resources;
    }

    private void addFile(IFile file, Map<String, IFile> files) {
        files.put(file.getLocation().toString(), file);
    }

    @Override
    public boolean isNotEmpty() {
        return true;
    }
}

