/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectusus.adapter.ICodeProportionComputationTarget;
import org.projectusus.adapter.StatusCollector;
import org.projectusus.adapter.TracingOption;
import org.projectusus.core.ExtensionCollector;
import org.projectusus.core.IUsusModelForAdapter;
import org.projectusus.core.basis.YellowCountCache;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.core.proportions.rawdata.jdtdriver.JavaFileDriver;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.core.util.FileSupport;

public class JDTDriver {
    private final IUsusModelForAdapter model = UsusModelProvider.ususModelForAdapter();
    private final ICodeProportionComputationTarget target;
    private Set<MetricsCollector> allExtensions;

    public JDTDriver(ICodeProportionComputationTarget target) {
        this.target = target;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        for (IProject removedProject : this.target.getRemovedProjects()) {
            this.model.dropRawData(removedProject);
            YellowCountCache.yellowCountCache().clear(removedProject);
        }
        monitor.beginTask(null, this.countTicks(this.target.getProjects()));
        for (IProject project : this.target.getProjects()) {
            monitor.subTask(project.getName());
            for (IFile removedFile : this.target.getRemovedFiles(project)) {
                this.model.dropRawData(removedFile);
            }
            YellowCountCache.yellowCountCache().add(project);
            this.computeChangedFiles(this.allExtensions(), project, monitor);
        }
        monitor.done();
    }

    private Set<MetricsCollector> allExtensions() {
        if (this.allExtensions == null) {
            this.allExtensions = new ExtensionCollector("org.projectusus.core.metrics").allExtensions();
        }
        return this.allExtensions;
    }

    private int countTicks(Collection<IProject> projects) throws CoreException {
        int result = 0;
        for (IProject project : projects) {
            result += this.target.getFiles(project).size();
        }
        return result;
    }

    private void computeChangedFiles(Set<MetricsCollector> metricsExtensions, IProject project, IProgressMonitor monitor) throws CoreException {
        Collection<IFile> files = this.target.getFiles(project);
        if (!files.isEmpty()) {
            StatusCollector statusCollector = new StatusCollector();
            this.runDriver(metricsExtensions, project, files, statusCollector, monitor);
            statusCollector.finish();
        }
    }

    private void runDriver(Set<MetricsCollector> metricsExtensions, IProject project, Collection<IFile> files, StatusCollector statusCollector, IProgressMonitor monitor) {
        this.computationStarted(project);
        for (IFile file : files) {
            this.fileStarted(file);
            this.runDriverOnFile(metricsExtensions, file, statusCollector, monitor);
        }
    }

    private void runDriverOnFile(Set<MetricsCollector> metricsExtensions, IFile file, StatusCollector statusCollector, IProgressMonitor monitor) {
        try {
            try {
                if (FileSupport.isJavaFile((IFile)file) && file.exists()) {
                    new JavaFileDriver(file).compute(metricsExtensions);
                }
            }
            catch (Exception ex) {
                statusCollector.add(ex);
                monitor.worked(1);
            }
        }
        finally {
            monitor.worked(1);
        }
    }

    private void computationStarted(IProject project) {
        TracingOption.SQI.trace("Computation started: " + project.toString());
    }

    private void fileStarted(IFile file) {
        TracingOption.SQI.trace("File started: " + file.getFullPath());
        this.model.dropRawData(file);
    }
}

