/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.projectusus.adapter.ChangedResourcesCollector;
import org.projectusus.adapter.ICodeProportionComputationTarget;

public class DeltaCodeProportionComputationTarget
implements ICodeProportionComputationTarget {
    private final Map<IProject, List<IFile>> changes;
    private final Map<IProject, List<IFile>> deletions;
    private final List<IProject> removedProjects;

    public DeltaCodeProportionComputationTarget(List<IResourceDelta> deltas) throws CoreException {
        ChangedResourcesCollector changeCollector = new ChangedResourcesCollector();
        for (IResourceDelta delta : deltas) {
            delta.accept((IResourceDeltaVisitor)changeCollector);
        }
        this.removedProjects = changeCollector.getRemovedProjects();
        this.changes = changeCollector.getChanges();
        this.deletions = changeCollector.getDeletions();
    }

    public DeltaCodeProportionComputationTarget(IResourceDelta delta) throws CoreException {
        this(DeltaCodeProportionComputationTarget.createList(delta));
    }

    private static <T> List<T> createList(T element) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    @Override
    public Collection<IFile> getFiles(IProject project) throws CoreException {
        return this.getFilesFrom(project, this.changes);
    }

    @Override
    public Collection<IProject> getProjects() {
        HashSet<IProject> result = new HashSet<IProject>();
        result.addAll(this.changes.keySet());
        result.addAll(this.deletions.keySet());
        return result;
    }

    @Override
    public Collection<IFile> getRemovedFiles(IProject project) throws CoreException {
        return this.getFilesFrom(project, this.deletions);
    }

    @Override
    public Collection<IProject> getRemovedProjects() {
        return Collections.unmodifiableList(this.removedProjects);
    }

    private Collection<IFile> getFilesFrom(IProject project, Map<IProject, List<IFile>> collector) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (collector.containsKey(project)) {
            result.addAll((Collection<IFile>)collector.get(project));
        }
        return result;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private boolean isEmpty() {
        return this.changes.isEmpty() && this.deletions.isEmpty() && this.removedProjects.isEmpty();
    }
}

