/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.projectusus.adapter.ICodeProportionComputationTarget;
import org.projectusus.adapter.JDTDriver;
import org.projectusus.core.statistics.UsusModelProvider;

public class CodeProportionsComputerJob
extends Job {
    public static final String codeProportionsComputerJob_computing = "Computing code proportions for Java files";
    public static final String codeProportionsComputerJob_name = "Code proportions computer";
    public static final Object FAMILY = new Object();
    private final ICodeProportionComputationTarget target;

    public CodeProportionsComputerJob(ICodeProportionComputationTarget target) {
        super(codeProportionsComputerJob_name);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setPriority(50);
        this.target = target;
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }

    protected IStatus run(IProgressMonitor mo) {
        IProgressMonitor monitor = mo == null ? new NullProgressMonitor() : mo;
        return this.performRun(monitor);
    }

    private IStatus performRun(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        monitor.beginTask(codeProportionsComputerJob_computing, 1000);
        try {
            try {
                this.computeJavaCodeMetrics((IProgressMonitor)new SubProgressMonitor(monitor, 700));
            }
            catch (CoreException cex) {
                result = cex.getStatus();
                this.updateModel(result, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                monitor.done();
            }
        }
        finally {
            this.updateModel(result, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
            monitor.done();
        }
        return result;
    }

    private void updateModel(IStatus result, IProgressMonitor monitor) {
        UsusModelProvider.ususModelForAdapter().updateAfterComputationRun(result.isOK(), monitor);
    }

    private void computeJavaCodeMetrics(IProgressMonitor monitor) throws CoreException {
        new JDTDriver(this.target).run(monitor);
    }
}

