/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.projectusus.adapter.TracingOption;
import org.projectusus.core.project2.UsusProjectSupport;
import org.projectusus.core.util.FileSupport;

class ChangedResourcesCollector
implements IResourceDeltaVisitor {
    private final List<IProject> removedProjects = new ArrayList<IProject>();
    private final Map<IProject, List<IFile>> changes = new HashMap<IProject, List<IFile>>();
    private final Map<IProject, List<IFile>> deletions = new HashMap<IProject, List<IFile>>();

    ChangedResourcesCollector() {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        boolean result = true;
        IResource resource = delta.getResource();
        if (this.handleRemovedProject(delta) || this.isNonUsusProject(resource)) {
            TracingOption.RESOURCE_CHANGES.trace("Removed " + resource.getFullPath());
            this.removedProjects.add((IProject)resource);
            result = false;
        } else if (resource instanceof IFile) {
            this.handleFileDelta(delta, (IFile)resource);
        }
        return result;
    }

    private boolean isNonUsusProject(IResource resource) {
        return resource instanceof IProject && !UsusProjectSupport.asUsusProject((IProject)((IProject)resource)).isUsusProject();
    }

    private boolean handleRemovedProject(IResourceDelta delta) {
        boolean result = false;
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            result = this.wasClosed(delta, project) || this.isDeleted(delta);
        }
        return result;
    }

    private boolean wasClosed(IResourceDelta delta, IProject project) {
        return this.isOpenCloseStatusChanged(delta) && !project.isOpen();
    }

    private void handleFileDelta(IResourceDelta delta, IFile file) {
        if (!FileSupport.isJavaFile((IFile)file)) {
            return;
        }
        if (this.isInteresting(delta)) {
            TracingOption.RESOURCE_CHANGES.trace("Changed file " + file.getFullPath());
            this.addToMap(file, this.changes);
        } else if (this.isDeleted(delta)) {
            TracingOption.RESOURCE_CHANGES.trace("Deleted file " + file.getFullPath());
            this.addToMap(file, this.deletions);
        }
    }

    private void addToMap(IFile file, Map<IProject, List<IFile>> collector) {
        IProject project = file.getProject();
        if (!collector.containsKey(project)) {
            collector.put(project, new ArrayList());
        }
        collector.get(project).add(file);
    }

    private boolean isOpenCloseStatusChanged(IResourceDelta delta) {
        return (delta.getFlags() & 0x4000) != 0;
    }

    private boolean isDeleted(IResourceDelta delta) {
        int kind = delta.getKind();
        return (kind & 2) != 0;
    }

    private boolean isInteresting(IResourceDelta delta) {
        boolean onlyMarkers;
        boolean added;
        int kind = delta.getKind();
        boolean changed = (kind & 4) != 0;
        boolean bl = added = (kind & 1) != 0;
        if (!added && !changed) {
            return false;
        }
        boolean bl2 = onlyMarkers = delta.getFlags() == 131072;
        if (onlyMarkers) {
            IMarkerDelta[] markerDeltas;
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta iMarkerDelta = iMarkerDeltaArray[n2];
                boolean markerComesFromJdt = "JDT".equals(iMarkerDelta.getAttribute("sourceId", null));
                if (markerComesFromJdt) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public List<IProject> getRemovedProjects() {
        return this.removedProjects;
    }

    public Map<IProject, List<IFile>> getChanges() {
        return this.changes;
    }

    public Map<IProject, List<IFile>> getDeletions() {
        return this.deletions;
    }
}

