/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.adapter;

import java.util.LinkedList;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.JavaCore;
import org.projectusus.adapter.RegisterPreferenceListenerForAllChildren;
import org.projectusus.adapter.RunComputationOnPreferencesChange;
import org.projectusus.adapter.RunComputationOnResourceChange;
import org.projectusus.adapter.UsusAdapterPlugin;
import org.projectusus.core.UsusCorePlugin;

public class AutoComputeSetting {
    private final IResourceChangeListener resourcelistener = new RunComputationOnResourceChange();
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new RunComputationOnPreferencesChange();
    private final IEclipsePreferences.INodeChangeListener nodeListener = new RegisterPreferenceListenerForAllChildren(this.preferenceChangeListener);

    public AutoComputeSetting() {
        this.applyAutoCompute(UsusAdapterPlugin.getDefault().getAutocompute());
    }

    public void setAutoCompute(boolean autoCompute) {
        this.applyAutoCompute(autoCompute);
    }

    public void dispose() {
        JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this.resourcelistener);
    }

    private void applyAutoCompute(boolean autoCompute) {
        if (autoCompute) {
            JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)this.resourcelistener, (int)16);
            this.hookPreferenceChanges();
        } else {
            JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this.resourcelistener);
            this.unhookPreferenceChanges();
        }
    }

    private void hookPreferenceChanges() {
        IEclipsePreferences preferences = this.getUsusProjectPreferences();
        preferences.addNodeChangeListener(this.nodeListener);
        for (IEclipsePreferences projectPreferences : this.collectChildren(preferences)) {
            projectPreferences.addPreferenceChangeListener(this.preferenceChangeListener);
        }
    }

    private void unhookPreferenceChanges() {
        IEclipsePreferences preferences = this.getUsusProjectPreferences();
        preferences.removeNodeChangeListener(this.nodeListener);
        for (IEclipsePreferences projectPreferences : this.collectChildren(preferences)) {
            projectPreferences.removePreferenceChangeListener(this.preferenceChangeListener);
        }
    }

    private Iterable<IEclipsePreferences> collectChildren(IEclipsePreferences preferences) {
        LinkedList<IEclipsePreferences> children = new LinkedList<IEclipsePreferences>();
        try {
            String[] stringArray = preferences.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String childName = stringArray[n2];
                IEclipsePreferences child = (IEclipsePreferences)preferences.node(childName);
                children.add(child);
                ++n2;
            }
        }
        catch (Exception exception) {
            this.log(exception);
        }
        return children;
    }

    private void log(Exception exception) {
        Status status = new Status(4, "org.projectusus.adapter", "Unable to read child names of Usus Project Preferences", (Throwable)exception);
        UsusAdapterPlugin.getDefault().getLog().log((IStatus)status);
    }

    private IEclipsePreferences getUsusProjectPreferences() {
        return (IEclipsePreferences)UsusCorePlugin.getDefault().getPreferences().node("ususProject");
    }
}

