/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.projectusus.projectsettings.core.Preferences;
import org.projectusus.projectsettings.core.SettingsProvider;

public class SettingsProviderExtension {
    private static final String EXTENSION_POINT_ID = "org.projectusus.projectsettings.core.settingsprovider";

    public List<SettingsProvider> loadSettingsProvider() {
        IConfigurationElement[] configurationElements;
        ArrayList<SettingsProvider> result = new ArrayList<SettingsProvider>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            SettingsProvider settingsProvider = this.getSettingsProvider(configurationElement);
            if (settingsProvider != null) {
                result.add(settingsProvider);
            }
            ++n2;
        }
        return result;
    }

    private SettingsProvider getSettingsProvider(IConfigurationElement configurationElement) {
        try {
            Object object = configurationElement.createExecutableExtension("clazz");
            if (object instanceof SettingsProvider) {
                return (SettingsProvider)object;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<Preferences> loadSettings() {
        ArrayList<Preferences> result = new ArrayList<Preferences>();
        for (SettingsProvider settingsProvider : this.loadSettingsProvider()) {
            result.add(settingsProvider.getUsusProjectSettings());
        }
        return result;
    }
}

