/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.core;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.projectusus.projectsettings.core.Preferences;
import org.projectusus.projectsettings.core.ProjectPreferences;
import org.projectusus.projectsettings.core.WhichPrefs;

public class SettingsAccess {
    public void transferSettingsFromProject(List<IProject> projects, IProject source, WhichPrefs[] whichPrefs) {
        ProjectPreferences projectPreferences = new ProjectPreferences(source);
        for (IProject project : projects) {
            this.save(project, projectPreferences, whichPrefs);
        }
    }

    public void applySettings(List<IProject> projects, Preferences settings) {
        if (settings == null) {
            return;
        }
        for (IProject project : projects) {
            this.save(project, settings, new WhichPrefs[]{WhichPrefs.All});
        }
    }

    private void save(IProject project, Preferences settings, WhichPrefs[] whichPrefs) {
        ProjectPreferences projectProperties = new ProjectPreferences(project);
        WhichPrefs[] whichPrefsArray = whichPrefs;
        int n = whichPrefs.length;
        int n2 = 0;
        while (n2 < n) {
            WhichPrefs prefs = whichPrefsArray[n2];
            switch (prefs) {
                case All: {
                    projectProperties.updateFrom(settings.getAll());
                    break;
                }
                case CodeCompletion: {
                    projectProperties.updateFrom(settings.getCodeCompletePrefs());
                    break;
                }
                case CompilerWarnings: {
                    projectProperties.updateFrom(settings.getCompilerWarningsPrefs());
                    break;
                }
                case Formatting: {
                    projectProperties.updateFrom(settings.getFormattingPrefs());
                    break;
                }
            }
            ++n2;
        }
        projectProperties.persist();
    }
}

