/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.core;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.projectusus.projectsettings.core.Preferences;
import org.projectusus.projectsettings.internal.util.CoreTexts;

public class ProjectPreferences
extends Preferences {
    private final IProject project;

    private static IEclipsePreferences getJdtPreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.jdt.core");
    }

    private static Properties getJdtPreferencesAsProperties(IProject project) {
        Properties properties = new Properties();
        try {
            IEclipsePreferences jdtPreferences = ProjectPreferences.getJdtPreferences(project);
            String[] stringArray = jdtPreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                properties.put(key, jdtPreferences.get(key, ""));
                ++n2;
            }
        }
        catch (BackingStoreException bse) {
            throw new RuntimeException(CoreTexts.Error_load_settings, bse);
        }
        return properties;
    }

    public ProjectPreferences(IProject project) {
        this(project, ProjectPreferences.getJdtPreferencesAsProperties(project));
    }

    ProjectPreferences(IProject project, Properties prefsAsProps) {
        super(NLS.bind((String)CoreTexts.projectSettings_settingsName, (Object)project.getName()), prefsAsProps);
        this.project = project;
    }

    public void persist() {
        IEclipsePreferences jdtPreferences = ProjectPreferences.getJdtPreferences(this.project);
        for (Object keyAsObject : this.getAll().keySet()) {
            String key = (String)keyAsObject;
            jdtPreferences.put(key, this.getAll().getProperty(key));
        }
        try {
            jdtPreferences.flush();
        }
        catch (BackingStoreException bse) {
            throw new RuntimeException(CoreTexts.Error_save_settings, bse);
        }
    }
}

