/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.projectsettings.core.Preferences;

public class PreferencesTest {
    private static final String fileName = "org.eclipse.jdt.core.prefs";
    private Properties properties;
    private Preferences prefs;

    @Before
    public void before() throws IOException {
        this.properties = new Properties();
        this.properties.load(this.getClass().getClassLoader().getResourceAsStream(fileName));
        this.prefs = new Preferences("myname", this.properties);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"myname", (Object)this.prefs.getName());
    }

    @Test
    public void testGetCodeCompletePrefs() {
        Properties all = this.prefs.getAll();
        Properties codeCompletePrefs = this.prefs.getCodeCompletePrefs();
        Assert.assertFalse((boolean)codeCompletePrefs.isEmpty());
        Enumeration<Object> elements = codeCompletePrefs.keys();
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            Assert.assertTrue((boolean)element.startsWith("org.eclipse.jdt.core.codeComplete"));
            Assert.assertTrue((boolean)all.containsKey(element));
        }
    }

    @Test
    public void testGetCompilerWarningsPrefs() {
        Properties all = this.prefs.getAll();
        Properties compilerWarningPrefs = this.prefs.getCompilerWarningsPrefs();
        Assert.assertFalse((boolean)compilerWarningPrefs.isEmpty());
        Enumeration<Object> elements = compilerWarningPrefs.keys();
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            Assert.assertTrue((boolean)element.startsWith("org.eclipse.jdt.core.compiler.problem"));
            Assert.assertTrue((boolean)all.containsKey(element));
        }
    }

    @Test
    public void testGetFormattingPrefs() {
        Properties all = this.prefs.getAll();
        Properties fromattingPrefs = this.prefs.getFormattingPrefs();
        Assert.assertFalse((boolean)fromattingPrefs.isEmpty());
        Enumeration<Object> elements = fromattingPrefs.keys();
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            Assert.assertTrue((boolean)element.startsWith("org.eclipse.jdt.core.formatter"));
            Assert.assertTrue((boolean)all.containsKey(element));
        }
    }

    @Test
    public void testUpdateFrom() {
        Preferences newPrefs = new Preferences("neu", new Properties());
        newPrefs.updateFrom(this.prefs.getCompilerWarningsPrefs());
        Assert.assertFalse((boolean)newPrefs.getAll().isEmpty());
        Assert.assertFalse((boolean)newPrefs.getCompilerWarningsPrefs().isEmpty());
        Assert.assertTrue((boolean)newPrefs.getCodeCompletePrefs().isEmpty());
        Assert.assertTrue((boolean)newPrefs.getFormattingPrefs().isEmpty());
    }
}

