/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.core;

import java.util.Properties;

public class Preferences {
    private static final String WARNINGS_PREFIX = "org.eclipse.jdt.core.compiler.problem.";
    private static final String CODE_COMPLETE_PREFIX = "org.eclipse.jdt.core.codeComplete.";
    private static final String FORMATTING_PREFIX = "org.eclipse.jdt.core.formatter.";
    private final String name;
    private Properties prefsAsProperties;

    public Preferences(String name, Properties prefsAsProps) {
        this.name = name;
        this.prefsAsProperties = prefsAsProps;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name=");
        result.append(this.getName());
        return result.toString();
    }

    public Properties getCodeCompletePrefs() {
        return this.getPropertiesForPrefix(CODE_COMPLETE_PREFIX);
    }

    public Properties getCompilerWarningsPrefs() {
        return this.getPropertiesForPrefix(WARNINGS_PREFIX);
    }

    public Properties getFormattingPrefs() {
        return this.getPropertiesForPrefix(FORMATTING_PREFIX);
    }

    public void updateFrom(Properties properties) {
        for (Object keyAsObject : properties.keySet()) {
            String key = (String)keyAsObject;
            this.prefsAsProperties.put(key, properties.getProperty(key));
        }
    }

    private Properties getPropertiesForPrefix(String prefix) {
        Properties properties = new Properties();
        for (Object keyAsObject : this.prefsAsProperties.keySet()) {
            String key = (String)keyAsObject;
            if (!key.startsWith(prefix)) continue;
            properties.put(key, this.prefsAsProperties.get(key));
        }
        return properties;
    }

    public Properties getAll() {
        return this.prefsAsProperties;
    }
}

