/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.statistics.test;

import org.junit.Assert;
import org.junit.Test;
import org.projectusus.core.basis.Histogram;

public class HistogramTest {
    @Test
    public void incrementOnce() {
        Histogram histogram = new Histogram();
        histogram.increment(1);
        Assert.assertEquals((long)1L, (long)histogram.countOf(1));
    }

    @Test
    public void incrementTwice() {
        Histogram histogram = new Histogram();
        histogram.increment(1);
        histogram.increment(1);
        Assert.assertEquals((long)2L, (long)histogram.countOf(1));
    }

    @Test
    public void incrementTwoDifferentNumbers() {
        Histogram histogram = new Histogram();
        histogram.increment(1);
        histogram.increment(2);
        Assert.assertEquals((long)1L, (long)histogram.countOf(1));
        Assert.assertEquals((long)1L, (long)histogram.countOf(2));
    }

    @Test
    public void collectAllValues() {
        Histogram histogram = new Histogram();
        histogram.increment(1);
        histogram.increment(3);
        histogram.increment(3);
        Assert.assertArrayEquals((double[])new double[]{1.0, 3.0}, (double[])histogram.allNumbers(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0}, (double[])histogram.allValues(), (double)1.0E-6);
    }
}

