/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.statistics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.projectusus.core.IMetricsResultVisitor;
import org.projectusus.core.IMetricsWriter;
import org.projectusus.core.IUsusModel;
import org.projectusus.core.IUsusModelForAdapter;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.UsusCorePlugin;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.ClassDescriptorCleanup;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.internal.proportions.model.UsusModelCache;
import org.projectusus.core.internal.proportions.rawdata.MetricsAccessor;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.core.statistics.RegisteredCockpitExtensionsCollector;

class UsusModel
implements IUsusModel,
IUsusModelForAdapter {
    private static UsusModel instance = new UsusModel(new ASTNodeHelper());
    private final Set<IUsusModelListener> listeners;
    private UsusModelCache cache = new UsusModelCache();
    private final MetricsAccessor metrics;
    private boolean needsFullRecompute;

    public static UsusModel ususModel() {
        return instance;
    }

    private UsusModel(ASTNodeHelper converter) {
        this.listeners = new HashSet<IUsusModelListener>();
        this.metrics = new MetricsAccessor(converter);
        this.needsFullRecompute = true;
    }

    @Override
    public void refreshCodeProportions() {
        this.updateAfterComputationRun(true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void updateAfterComputationRun(boolean computationSuccessful, IProgressMonitor monitor) {
        this.needsFullRecompute = !computationSuccessful;
        this.metrics.cleanupRelations(monitor);
        this.runStatisticsExtensions();
        this.notifyListeners();
    }

    private void runStatisticsExtensions() {
        this.cache = new UsusModelCache();
        for (final CockpitExtension cockpitExtension : RegisteredCockpitExtensionsCollector.getEnabled()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    UsusCorePlugin.log(exception);
                }

                public void run() throws Exception {
                    cockpitExtension.visit();
                    UsusModel.this.cache.refresh(cockpitExtension.getCodeProportion());
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    @Override
    public void dropRawData(IProject project) {
        this.metrics.dropRawData(project);
    }

    @Override
    public void dropRawData(IFile file) {
        this.metrics.dropRawData(file);
    }

    public void acceptAndGuide(IMetricsResultVisitor visitor) {
        this.metrics.acceptAndGuide(visitor);
    }

    public IMetricsWriter getMetricsWriter() {
        return this.metrics;
    }

    @Override
    public List<CodeProportion> getCodeProportions() {
        return this.cache.getEntries();
    }

    @Override
    public void addUsusModelListener(IUsusModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUsusModelListener(IUsusModelListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IUsusModelListener listener : this.listeners) {
            listener.ususModelChanged();
        }
    }

    @Override
    public boolean needsFullRecompute() {
        return this.needsFullRecompute;
    }

    public static void clear(ASTNodeHelper converter) {
        instance = new UsusModel(converter);
        ClassDescriptor.clear();
        ClassDescriptorCleanup.clear();
        Packagename.clear();
    }

    @Override
    public void aboutToStartFullRecompute() {
        this.needsFullRecompute = false;
    }
}

