/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.statistics;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.projectusus.core.ExtensionCollector;
import org.projectusus.core.UsusCorePlugin;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.core.statistics.CockpitExtensionPref;
import org.projectusus.core.statistics.CockpitExtensionPrefComparator;

public class RegisteredCockpitExtensionsCollector {
    private static final String STATISTICS_EXTENSIONS = "statistics-extensions";
    private static final String ENABLED = "enabled";
    private static final Function<CockpitExtension, CockpitExtensionPref> toExtensionPref = new Function<CockpitExtension, CockpitExtensionPref>(){

        public CockpitExtensionPref apply(CockpitExtension extension) {
            return new CockpitExtensionPref(extension.getClass().getName(), extension.getLabel());
        }
    };

    private RegisteredCockpitExtensionsCollector() {
    }

    public static Set<CockpitExtension> getEnabled() {
        final SortedSet<CockpitExtensionPref> allStates = RegisteredCockpitExtensionsCollector.getExtensionsStates();
        return Sets.filter(RegisteredCockpitExtensionsCollector.allExtensions(), (Predicate)new Predicate<CockpitExtension>(){

            public boolean apply(CockpitExtension extension) {
                return RegisteredCockpitExtensionsCollector.isEnabled(extension, allStates);
            }
        });
    }

    private static boolean isEnabled(CockpitExtension extension, Set<CockpitExtensionPref> allStates) {
        CockpitExtensionPref extensionPref = RegisteredCockpitExtensionsCollector.findByClassName(allStates, extension.getClass().getName());
        return extensionPref == null ? true : extensionPref.isOn();
    }

    public static Set<CockpitExtension> allExtensions() {
        return new ExtensionCollector("org.projectusus.core.statistics").allExtensions();
    }

    private static Set<CockpitExtensionPref> getAllPresentExtensions() {
        return Sets.newHashSet((Iterable)Collections2.transform(RegisteredCockpitExtensionsCollector.allExtensions(), toExtensionPref));
    }

    public static SortedSet<CockpitExtensionPref> getExtensionsStates() {
        Set<CockpitExtensionPref> extensions = RegisteredCockpitExtensionsCollector.getAllPresentExtensions();
        Set<CockpitExtensionPref> known = RegisteredCockpitExtensionsCollector.getAllKnownExtensions();
        for (CockpitExtensionPref extension : extensions) {
            CockpitExtensionPref pref = RegisteredCockpitExtensionsCollector.findByClassName(known, extension.getClassName());
            if (pref == null) continue;
            extension.setOn(pref.isOn());
        }
        return RegisteredCockpitExtensionsCollector.sort(extensions);
    }

    private static CockpitExtensionPref findByClassName(Set<CockpitExtensionPref> extensions, String className) {
        Set filtered = Sets.filter(extensions, (Predicate)Predicates.equalTo((Object)new CockpitExtensionPref(className, true)));
        return (CockpitExtensionPref)Iterables.getOnlyElement((Iterable)filtered, null);
    }

    private static SortedSet<CockpitExtensionPref> sort(Set<CockpitExtensionPref> extensions) {
        TreeSet<CockpitExtensionPref> sorted = new TreeSet<CockpitExtensionPref>(new CockpitExtensionPrefComparator());
        sorted.addAll(extensions);
        return sorted;
    }

    private static Set<CockpitExtensionPref> getAllKnownExtensions() {
        HashSet known = Sets.newHashSet();
        Preferences preferences = RegisteredCockpitExtensionsCollector.loadPreferences();
        String[] stringArray = RegisteredCockpitExtensionsCollector.childrenNames(preferences);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            Preferences node = preferences.node(className);
            boolean on = node.getBoolean(ENABLED, true);
            known.add(new CockpitExtensionPref(className, on));
            ++n2;
        }
        return known;
    }

    private static Preferences loadPreferences() {
        return UsusCorePlugin.getDefault().getPreferences().node(STATISTICS_EXTENSIONS);
    }

    public static void saveExtensionsStates(Set<CockpitExtensionPref> states) {
        Preferences preferences = RegisteredCockpitExtensionsCollector.loadPreferences();
        String[] stringArray = RegisteredCockpitExtensionsCollector.childrenNames(preferences);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            preferences.remove(string);
            ++n2;
        }
        for (CockpitExtensionPref extensionPref : states) {
            Preferences node = preferences.node(extensionPref.getClassName());
            node.putBoolean(ENABLED, extensionPref.isOn());
        }
    }

    private static String[] childrenNames(Preferences extensions) {
        try {
            return extensions.childrenNames();
        }
        catch (BackingStoreException exception) {
            RegisteredCockpitExtensionsCollector.log(exception);
            return new String[0];
        }
    }

    private static void log(Throwable throwable) {
        UsusCorePlugin.log(throwable);
    }
}

