/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.statistics;

import java.text.MessageFormat;

public class CockpitExtensionPref {
    public static final boolean ON_BY_DEFAULT = true;
    private final String className;
    private final String label;
    private boolean on;

    public CockpitExtensionPref(String className, String label) {
        this(className, label, true);
    }

    public CockpitExtensionPref(String className, boolean on) {
        this(className, null, on);
    }

    protected CockpitExtensionPref(String className, String label, boolean on) {
        this.className = className;
        this.label = label;
        this.on = on;
    }

    public String getLabel() {
        return this.label;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isOn() {
        return this.on;
    }

    public String toString() {
        return MessageFormat.format("{0} ({1}) [{2}]", this.label, this.className, this.onOrOff());
    }

    private String onOrOff() {
        return this.on ? "on" : "off";
    }

    public void setOn(boolean checked) {
        this.on = checked;
    }

    public void resetOnToDefault() {
        this.setOn(true);
    }

    public static void restoreDefaults(Iterable<CockpitExtensionPref> extensions) {
        for (CockpitExtensionPref pref : extensions) {
            pref.resetOnToDefault();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CockpitExtensionPref) {
            CockpitExtensionPref other = (CockpitExtensionPref)obj;
            return this.className.equals(other.className);
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

