/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.projectusus.core.CollectibleExtension;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.CodeStatistic;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.core.basis.Histogram;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.LocationType;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SinglePackageHotspot;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.DefaultMetricsResultVisitor;

public abstract class CockpitExtension
extends DefaultMetricsResultVisitor
implements CollectibleExtension {
    public static final String EXTENSION_POINT_ID = "org.projectusus.core.statistics";
    private final String unit;
    private final int violationLimit;
    private int basis;
    private int violations;
    private int violationSum;
    private List<Hotspot> hotspots;
    private Histogram histogram;
    private IProject currentProject;
    private IFile currentFile;

    public CockpitExtension(String unit, int violationLimit) {
        this.unit = unit;
        this.violationLimit = violationLimit;
        this.reset();
    }

    private void reset() {
        this.basis = 0;
        this.violations = 0;
        this.violationSum = 0;
        this.hotspots = new ArrayList<Hotspot>();
        this.histogram = new Histogram();
    }

    protected void addResult(SourceCodeLocation location, int count) {
        this.incrementState(count, new FileHotspot(location, count, this.currentFile));
    }

    protected void addResult(Packagename pkg, int count, Set<ClassDescriptor> set) {
        this.incrementState(count, new SinglePackageHotspot(pkg, count, this.currentProject.getName(), set));
    }

    private void incrementState(int count, Hotspot hotspot) {
        ++this.basis;
        this.histogram.increment(count);
        this.violationSum += count;
        if (count > this.violationLimit) {
            ++this.violations;
            this.hotspots.add(hotspot);
        }
    }

    @Override
    public void inspectProject(IProject project, MetricsResults results) {
        this.currentProject = project;
    }

    @Override
    public void inspectFile(IFile file, MetricsResults result) {
        this.currentFile = file;
    }

    public int getMetricsSum() {
        return this.violationSum;
    }

    public int getViolations() {
        return this.violations;
    }

    public int getBasis() {
        return this.basis;
    }

    public CodeStatistic getBasisStatistic() {
        return new CodeStatistic(this.unit, this.getBasis());
    }

    public double getAverage() {
        return CockpitExtension.calculateAverage(this.getViolations(), this.getBasis());
    }

    public List<Hotspot> getHotspots() {
        return this.hotspots;
    }

    public CodeProportion getCodeProportion() {
        return new CodeProportion(this.getLabel(), this.getDescription(), this.getTooltip(), this.getViolations(), this.getBasisStatistic(), this.getAverage(), this.getHotspots(), this.getHistogram(), this.getLocationType());
    }

    protected LocationType getLocationType() {
        return LocationType.PATH;
    }

    protected String getDescription() {
        return "Hotspots are " + this.unit + " " + this.hotspotsAreUnits() + this.getRatingFunction();
    }

    protected abstract String hotspotsAreUnits();

    protected String getTooltip() {
        return this.getDescription();
    }

    public static double calculateAverage(double numberOfViolations, double numberOfBaseElems) {
        if (numberOfBaseElems == 0.0) {
            return 0.0;
        }
        return 100.0 * numberOfViolations / numberOfBaseElems;
    }

    protected Histogram getHistogram() {
        return this.histogram;
    }

    protected String format(String string, int value) {
        return String.format(string, value);
    }

    protected String format(String string, int value1, int value2) {
        return String.format(string, value1, value2);
    }

    protected String getRatingFunction() {
        return this.linearRatingFunction(this.violationLimit);
    }

    private String linearRatingFunction(int limit) {
        return this.format("\nRating function: f(value) = 1/%d value - 1", limit);
    }
}

