/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.proportions.rawdata.jdtdriver;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.core.statistics.UsusModelProvider;

public class JavaFileDriver {
    private final IFile file;

    public JavaFileDriver(IFile file) {
        this.file = file;
    }

    public void compute(Set<MetricsCollector> metricsExtensions) {
        CompilationUnit compilationUnit = this.parseFile();
        for (MetricsCollector visitor : metricsExtensions) {
            this.setup(visitor);
            compilationUnit.accept((ASTVisitor)visitor);
        }
    }

    private void setup(MetricsCollector visitor) {
        visitor.setup(this.file, UsusModelProvider.getMetricsWriter());
    }

    private CompilationUnit parseFile() {
        return JavaFileDriver.parse(JavaCore.createCompilationUnitFrom((IFile)this.file));
    }

    private static CompilationUnit parse(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setSource(unit);
        return (CompilationUnit)parser.createAST(null);
    }
}

