/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.projectusus.core.project2.UsusProjectSupport;

public class FindUsusProjects {
    private final Iterable<IProject> candidates;

    private static Iterable<IProject> asProjectList(Object[] elements) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IProject) {
                projects.add((IProject)element);
            }
            ++n2;
        }
        return projects;
    }

    public FindUsusProjects(Iterable<IProject> candidates) {
        this.candidates = candidates;
    }

    public FindUsusProjects(IProject[] candidates) {
        this(Arrays.asList(candidates));
    }

    public FindUsusProjects(Object[] candidates) {
        this(FindUsusProjects.asProjectList(candidates));
    }

    public List<IProject> compute() {
        return this.compute(true);
    }

    public List<IProject> computeOpposite() {
        return this.compute(false);
    }

    private List<IProject> compute(boolean findUsusProjects) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : this.candidates) {
            if (findUsusProjects != UsusProjectSupport.asUsusProject(project).isUsusProject()) continue;
            result.add(project);
        }
        return Collections.unmodifiableList(result);
    }
}

