/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.rawdata.test;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.basis.JavaModelPath;

public class MetricsResultPathTest {
    private IProject project;
    private IFile file;
    private IType type;
    private IMethod method;

    @Before
    public void setup() throws JavaModelException {
        this.project = (IProject)Mockito.mock(IProject.class);
        this.file = this.getFileMockFor(this.project);
        this.type = this.getTypeMockFor(this.file);
        this.method = this.getMethodMockFor(this.type);
    }

    @Test
    public void defaultIsUnrestricted() {
        JavaModelPath result = new JavaModelPath();
        Assert.assertFalse((boolean)result.isRestrictedToProject());
        Assert.assertFalse((boolean)result.isRestrictedToFile());
        Assert.assertFalse((boolean)result.isRestrictedToType());
        Assert.assertFalse((boolean)result.isRestrictedToMethod());
    }

    @Test
    public void restrictedToProject() {
        JavaModelPath result = new JavaModelPath(this.project);
        Assert.assertTrue((boolean)result.isRestrictedToProject());
        Assert.assertFalse((boolean)result.isRestrictedToFile());
        Assert.assertFalse((boolean)result.isRestrictedToType());
        Assert.assertFalse((boolean)result.isRestrictedToMethod());
    }

    @Test
    public void restrictedToProjectGetProject() {
        JavaModelPath result = new JavaModelPath(this.project);
        Assert.assertEquals((Object)this.project, (Object)result.getProject());
    }

    @Test
    public void restrictedToFile() {
        JavaModelPath result = new JavaModelPath(this.file);
        Assert.assertTrue((boolean)result.isRestrictedToProject());
        Assert.assertTrue((boolean)result.isRestrictedToFile());
        Assert.assertFalse((boolean)result.isRestrictedToType());
        Assert.assertFalse((boolean)result.isRestrictedToMethod());
    }

    @Test
    public void restrictedToFileGetProjectAndFile() {
        JavaModelPath result = new JavaModelPath(this.file);
        Assert.assertEquals((Object)this.file, (Object)result.getFile());
        Assert.assertEquals((Object)this.project, (Object)result.getProject());
    }

    @Test
    public void restrictedToType() throws JavaModelException {
        JavaModelPath result = new JavaModelPath(this.type);
        Assert.assertTrue((boolean)result.isRestrictedToProject());
        Assert.assertTrue((boolean)result.isRestrictedToFile());
        Assert.assertTrue((boolean)result.isRestrictedToType());
        Assert.assertFalse((boolean)result.isRestrictedToMethod());
    }

    @Test
    public void restrictedToFileGetProjectToType() throws JavaModelException {
        JavaModelPath result = new JavaModelPath(this.type);
        Assert.assertEquals((Object)this.type, (Object)result.getType());
        Assert.assertEquals((Object)this.file, (Object)result.getFile());
        Assert.assertEquals((Object)this.project, (Object)result.getProject());
    }

    @Test
    public void restrictedToMethod() throws JavaModelException {
        JavaModelPath result = new JavaModelPath(this.method);
        Assert.assertTrue((boolean)result.isRestrictedToProject());
        Assert.assertTrue((boolean)result.isRestrictedToFile());
        Assert.assertTrue((boolean)result.isRestrictedToType());
        Assert.assertTrue((boolean)result.isRestrictedToMethod());
    }

    @Test
    public void restrictedToMethodGetProjectToMethod() throws JavaModelException {
        JavaModelPath result = new JavaModelPath(this.method);
        Assert.assertEquals((Object)this.method, (Object)result.getMethod());
        Assert.assertEquals((Object)this.type, (Object)result.getType());
        Assert.assertEquals((Object)this.file, (Object)result.getFile());
        Assert.assertEquals((Object)this.project, (Object)result.getProject());
    }

    private IMethod getMethodMockFor(IType typeToReturn) {
        IMethod methodMock = (IMethod)Mockito.mock(IMethod.class);
        Mockito.when((Object)methodMock.getAncestor(7)).thenReturn((Object)typeToReturn);
        return methodMock;
    }

    private IFile getFileMockFor(IProject projectToReturn) {
        IFile fileMock = (IFile)Mockito.mock(IFile.class);
        Mockito.when((Object)fileMock.getProject()).thenReturn((Object)projectToReturn);
        return fileMock;
    }

    private IType getTypeMockFor(IFile fileToReturn) throws JavaModelException {
        IType typeMock = (IType)Mockito.mock(IType.class);
        Mockito.when((Object)typeMock.getUnderlyingResource()).thenReturn((Object)fileToReturn);
        return typeMock;
    }
}

