/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.rawdata;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.projectusus.core.IMetricsResultVisitor;
import org.projectusus.core.basis.JavaModelPath;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.BoundTypeConverter;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.internal.proportions.rawdata.ProjectRawData;
import org.projectusus.core.internal.proportions.rawdata.RawData;

class WorkspaceRawData
extends RawData<IProject, ProjectRawData> {
    private BoundTypeConverter converter;
    private ASTNodeHelper nodeHelper;

    public WorkspaceRawData(ASTNodeHelper nodeHelper) {
        this.nodeHelper = nodeHelper;
        this.converter = new BoundTypeConverter(nodeHelper);
    }

    private ProjectRawData getOrCreateProjectRawData(IProject project) {
        ProjectRawData rawData = this.getProjectRawData(project);
        if (rawData == null) {
            rawData = new ProjectRawData(project);
            super.addRawData(project, rawData);
        }
        return rawData;
    }

    private ProjectRawData getProjectRawData(IProject project) {
        return (ProjectRawData)super.getRawData(project);
    }

    public void dropRawData(IProject project) {
        ProjectRawData projectRawData = this.getProjectRawData(project);
        if (projectRawData != null) {
            projectRawData.dropRawData();
            this.remove(project);
        }
    }

    public void dropRawData(IFile file) {
        ProjectRawData projectRawData = this.getProjectRawData(file.getProject());
        if (projectRawData != null) {
            projectRawData.dropRawData(file);
        }
    }

    public void acceptAndGuide(IMetricsResultVisitor visitor) {
        JavaModelPath path = visitor.getPath();
        if (path.isRestrictedToProject()) {
            ProjectRawData projectRawData = this.getProjectRawData(path.getProject());
            if (projectRawData != null) {
                projectRawData.acceptAndGuide(visitor);
            }
        } else {
            for (ProjectRawData projectRD : this.getAllRawDataElements()) {
                projectRD.acceptAndGuide(visitor);
            }
        }
    }

    public void putData(IFile file, MethodDeclaration methodDecl, String dataKey, Object value) {
        WrappedTypeBinding boundType = this.converter.wrap(this.nodeHelper.findEnclosingClassOf((ASTNode)methodDecl));
        if (boundType == null) {
            return;
        }
        ProjectRawData projectRawData = this.getOrCreateProjectRawData(file.getProject());
        if (projectRawData != null) {
            projectRawData.putData(boundType, file, methodDecl, this.nodeHelper, dataKey, value);
        }
    }

    public void putData(IFile file, Initializer initializer, String dataKey, Object value) {
        WrappedTypeBinding boundType = this.converter.wrap(this.nodeHelper.findEnclosingClassOf((ASTNode)initializer));
        if (boundType == null) {
            return;
        }
        ProjectRawData projectRawData = this.getOrCreateProjectRawData(file.getProject());
        if (projectRawData != null) {
            projectRawData.putData(boundType, file, initializer, this.nodeHelper, dataKey, value);
        }
    }

    public void putData(IFile file, AbstractTypeDeclaration node, String dataKey, Object value) {
        WrappedTypeBinding boundType = this.converter.wrap(node);
        if (boundType == null) {
            return;
        }
        ProjectRawData projectRawData = this.getOrCreateProjectRawData(file.getProject());
        if (projectRawData != null) {
            projectRawData.putData(boundType, file, node, this.nodeHelper, dataKey, value);
        }
    }

    public void removeRelationIfTargetIsGone(ClassDescriptor descriptor) {
        ProjectRawData projectRawData = this.getProjectRawData(descriptor.getFile().getProject());
        if (projectRawData != null) {
            projectRawData.removeRelationIfTargetIsGone(descriptor);
        } else {
            descriptor.removeFromPool();
        }
    }
}

