/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.rawdata;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.projectusus.core.IMetricsResultVisitor;
import org.projectusus.core.basis.JavaModelPath;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.internal.proportions.rawdata.FileRawData;
import org.projectusus.core.internal.proportions.rawdata.RawData;

class PackageRawData
extends RawData<IFile, FileRawData> {
    MetricsResults data;
    private Packagename pkg;

    public PackageRawData(Packagename pkg) {
        this.pkg = pkg;
        this.data = new MetricsResults();
    }

    private FileRawData getOrCreateFileRawData(IFile file, ASTNodeHelper nodeHelper) {
        FileRawData rawData = this.getFileRawData(file);
        if (rawData == null) {
            rawData = this.createFileRawData(file, nodeHelper);
        }
        return rawData;
    }

    private FileRawData getFileRawData(IFile file) {
        return (FileRawData)super.getRawData(file);
    }

    private FileRawData createFileRawData(IFile file, ASTNodeHelper nodeHelper) {
        FileRawData rawData = new FileRawData(file, nodeHelper);
        super.addRawData(file, rawData);
        return rawData;
    }

    public void dropRawData(IFile file) {
        FileRawData fileRawData = this.getFileRawData(file);
        if (fileRawData != null) {
            fileRawData.dropRawData();
        }
        this.remove(file);
    }

    public void dropRawData() {
        for (FileRawData fileRD : this.getAllRawDataElements()) {
            fileRD.dropRawData();
        }
        this.removeAll();
    }

    public void acceptAndGuide(IMetricsResultVisitor visitor) {
        this.updateData();
        visitor.inspectPackage(this.pkg, this.data);
        JavaModelPath path = visitor.getPath();
        if (path.isRestrictedToFile()) {
            this.getFileRawData(path.getFile()).acceptAndGuide(visitor);
        } else {
            for (FileRawData rawData : this.getAllRawDataElements()) {
                rawData.acceptAndGuide(visitor);
            }
        }
    }

    private void updateData() {
        this.data.put("NumberOfClasses", (Object)this.getRawDataElementCount());
    }

    public void putData(WrappedTypeBinding boundType, IFile file, MethodDeclaration methodDecl, ASTNodeHelper nodeHelper, String dataKey, Object value) {
        FileRawData fileRawData = this.getOrCreateFileRawData(file, nodeHelper);
        if (fileRawData != null) {
            fileRawData.putData(boundType, methodDecl, dataKey, value);
        }
    }

    public void putData(WrappedTypeBinding boundType, IFile file, Initializer initializer, ASTNodeHelper nodeHelper, String dataKey, Object value) {
        FileRawData fileRawData = this.getOrCreateFileRawData(file, nodeHelper);
        if (fileRawData != null) {
            fileRawData.putData(boundType, initializer, dataKey, value);
        }
    }

    public void putData(WrappedTypeBinding boundType, IFile file, AbstractTypeDeclaration node, ASTNodeHelper nodeHelper, String dataKey, Object value) {
        FileRawData fileRawData = this.getOrCreateFileRawData(file, nodeHelper);
        if (fileRawData != null) {
            fileRawData.putData(boundType, node, dataKey, value);
        }
    }

    public void removeRelationIfTargetIsGone(ClassDescriptor descriptor) {
        IFile targetFile = descriptor.getFile();
        FileRawData fileRawData = this.getFileRawData(targetFile);
        if (fileRawData == null) {
            descriptor.removeFromPool();
        } else {
            fileRawData.removeRelationIfTargetIsGone(descriptor);
        }
    }
}

