/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.rawdata;

import net.sourceforge.c4j.ContractReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.projectusus.core.IMetricsResultVisitor;
import org.projectusus.core.basis.JavaModelPath;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.internal.proportions.rawdata.ClassRawData;
import org.projectusus.core.internal.proportions.rawdata.JDTSupport;
import org.projectusus.core.internal.proportions.rawdata.RawData;

@ContractReference(contractClassName="FileRawDataContract")
public class FileRawData
extends RawData<Integer, ClassRawData> {
    private MetricsResults data;
    private final IFile file;
    private final ASTNodeHelper nodeHelper;

    public FileRawData(IFile file, ASTNodeHelper nodeHelper) {
        this.file = file;
        this.nodeHelper = nodeHelper;
        this.data = new MetricsResults();
    }

    public String toString() {
        return "Data for " + this.file.getFullPath() + ", " + this.getRawDataElementCount() + " classes";
    }

    public void putData(WrappedTypeBinding boundType, MethodDeclaration methodDecl, String dataKey, Object value) {
        ClassRawData classRawData = this.getOrCreateClassRawData(boundType, methodDecl);
        if (classRawData != null) {
            classRawData.putData(methodDecl, dataKey, value);
        }
    }

    public void putData(WrappedTypeBinding boundType, Initializer initializer, String dataKey, Object value) {
        ClassRawData classRawData = this.getOrCreateClassRawData(boundType, initializer);
        if (classRawData != null) {
            classRawData.putData(initializer, dataKey, value);
        }
    }

    public void putData(WrappedTypeBinding boundType, AbstractTypeDeclaration node, String dataKey, Object value) {
        ClassRawData classRawData = this.getOrCreateClassRawData(boundType, node);
        if (classRawData != null) {
            classRawData.putData(dataKey, value);
        }
    }

    private ClassRawData getOrCreateClassRawData(WrappedTypeBinding boundType, AbstractTypeDeclaration node) {
        return this.getOrCreateClassRawData(boundType, this.nodeHelper.getStartPositionFor((ASTNode)node), this.nodeHelper.calcLineNumberFor((ASTNode)node), node.getName().toString());
    }

    private ClassRawData getOrCreateClassRawData(WrappedTypeBinding typeBinding, int start, int lineNumber, String name) {
        Integer startObject = start;
        ClassRawData rawData = (ClassRawData)super.getRawData(startObject);
        if (rawData == null) {
            rawData = new ClassRawData(typeBinding, name, this.nodeHelper, start, lineNumber);
            super.addRawData(startObject, rawData);
        }
        return rawData;
    }

    private ClassRawData getOrCreateClassRawData(WrappedTypeBinding boundType, MethodDeclaration node) {
        return this.getOrCreateClassRawData(boundType, this.nodeHelper.findEnclosingClassOf((ASTNode)node));
    }

    private ClassRawData getOrCreateClassRawData(WrappedTypeBinding boundType, Initializer node) {
        return this.getOrCreateClassRawData(boundType, this.nodeHelper.findEnclosingClassOf((ASTNode)node));
    }

    private ClassRawData getClassRawData(IJavaElement element) {
        ICompilationUnit compilationUnit = JDTSupport.getCompilationUnit(element);
        if (compilationUnit != null) {
            try {
                return this.getClassRawData(element, compilationUnit);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private ClassRawData getClassRawData(IJavaElement element, ICompilationUnit compilationUnit) throws JavaModelException {
        for (Integer startPosition : this.getAllKeys()) {
            IJavaElement foundElement = compilationUnit.getElementAt(startPosition.intValue());
            if (!element.equals(foundElement)) continue;
            return (ClassRawData)super.getRawData(startPosition);
        }
        return null;
    }

    private ClassRawData findClass(Classname classname) {
        for (ClassRawData classRD : this.getAllRawDataElements()) {
            if (!classRD.isCalled(classname)) continue;
            return classRD;
        }
        return null;
    }

    public void dropRawData() {
        for (ClassRawData classRD : this.getAllRawDataElements()) {
            classRD.dropRawData();
        }
        this.removeAll();
    }

    public void acceptAndGuide(IMetricsResultVisitor visitor) {
        visitor.inspectFile(this.file, this.data);
        JavaModelPath path = visitor.getPath();
        if (path.isRestrictedToType()) {
            this.getClassRawData(path.getType()).acceptAndGuide(visitor);
        } else {
            for (ClassRawData classRD : this.getAllRawDataElements()) {
                classRD.acceptAndGuide(visitor);
            }
        }
    }

    public void removeRelationIfTargetIsGone(ClassDescriptor descriptor) {
        ClassRawData classRawData = this.findClass(descriptor.getClassname());
        if (classRawData == null) {
            descriptor.removeFromPool();
        }
    }
}

