/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.internal.proportions.rawdata;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.projectusus.core.IMetricsResultVisitor;
import org.projectusus.core.basis.JavaModelPath;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.internal.proportions.rawdata.JDTSupport;
import org.projectusus.core.internal.proportions.rawdata.MethodRawData;
import org.projectusus.core.internal.proportions.rawdata.RawData;

public class ClassRawData
extends RawData<Integer, MethodRawData> {
    private final SourceCodeLocation location;
    private MetricsResults data;
    private ClassDescriptor descriptor;
    private ASTNodeHelper nodeHelper;

    public ClassRawData(WrappedTypeBinding binding, String name, ASTNodeHelper nodeHelper, int startPosition, int line) {
        this.nodeHelper = nodeHelper;
        this.location = new SourceCodeLocation(name, startPosition, line);
        this.data = new MetricsResults();
        this.descriptor = ClassDescriptor.of(binding);
    }

    public String toString() {
        return "Class " + this.location.getName() + " in line " + this.location.getLineNumber() + " with " + this.getRawDataElementCount() + " methods.";
    }

    void putData(MethodDeclaration node, String dataKey, Object value) {
        MethodRawData methodRawData = this.getOrCreateMethodRawData(node);
        if (methodRawData != null) {
            methodRawData.putData(dataKey, value);
        }
    }

    void putData(Initializer node, String dataKey, Object value) {
        MethodRawData methodRawData = this.getOrCreateMethodRawData(node);
        if (methodRawData != null) {
            methodRawData.putData(dataKey, value);
        }
    }

    private MethodRawData getOrCreateMethodRawData(MethodDeclaration node) {
        return this.getOrCreateMethodRawData(this.nodeHelper.getStartPositionFor((ASTNode)node), this.nodeHelper.calcLineNumberFor((ASTNode)node), node.getName().toString());
    }

    private MethodRawData getOrCreateMethodRawData(Initializer node) {
        return this.getOrCreateMethodRawData(this.nodeHelper.getStartPositionFor((ASTNode)node), this.nodeHelper.calcLineNumberFor((ASTNode)node), "initializer");
    }

    private MethodRawData getOrCreateMethodRawData(IMethod method) {
        ICompilationUnit compilationUnit = JDTSupport.getCompilationUnit((IJavaElement)method);
        if (compilationUnit == null) {
            return null;
        }
        try {
            for (Integer start : this.getAllKeys()) {
                IJavaElement foundElement = compilationUnit.getElementAt(start.intValue());
                if (!method.equals(foundElement)) continue;
                return this.getOrCreateMethodRawData(start, 0, "");
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private MethodRawData getOrCreateMethodRawData(int start, int lineNr, String methodName) {
        Integer startObject = new Integer(start);
        MethodRawData rawData = (MethodRawData)super.getRawData(startObject);
        if (rawData == null) {
            rawData = new MethodRawData(start, lineNr, this.location.getName(), methodName);
            super.addRawData(startObject, rawData);
        }
        return rawData;
    }

    public void dropRawData() {
        if (this.descriptor != null) {
            this.descriptor.prepareRemoval();
        }
    }

    public void acceptAndGuide(IMetricsResultVisitor visitor) {
        this.updateData();
        visitor.inspectClass(this.location, this.data);
        JavaModelPath path = visitor.getPath();
        if (path.isRestrictedToMethod()) {
            this.getOrCreateMethodRawData(path.getMethod()).acceptAndGuide(visitor);
        } else {
            for (MethodRawData rawData : this.getAllRawDataElements()) {
                rawData.acceptAndGuide(visitor);
            }
        }
    }

    private void updateData() {
        this.putData("NumberOfMethods", this.getRawDataElementCount());
        this.putData("CCD", this.descriptor.getCCD());
    }

    private void putData(String dataKey, int value) {
        this.data.put(dataKey, (Object)value);
    }

    public void putData(String dataKey, Object value) {
        this.data.put(dataKey, value);
    }

    public boolean isCalled(Classname classname) {
        return this.location.getName().equals(classname.toString());
    }
}

