/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.TypeBindingChecker;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.project2.IUSUSProject;

public class TypeBindingCheckerTest {
    private ITypeBinding binding = (ITypeBinding)Mockito.mock(ITypeBinding.class);
    private IFile resource = (IFile)Mockito.mock(IFile.class);
    private IJavaElement javaElement = (IJavaElement)Mockito.mock(IJavaElement.class);
    private IProject project = (IProject)Mockito.mock(IProject.class);
    private IUSUSProject adapter = (IUSUSProject)Mockito.mock(IUSUSProject.class);
    private IPackageBinding packg = (IPackageBinding)Mockito.mock(IPackageBinding.class);
    private IJavaElement packageJavaElement = (IJavaElement)Mockito.mock(IJavaElement.class);
    private TypeBindingChecker checker = new TypeBindingChecker();

    @Before
    public void setup() throws JavaModelException {
        Mockito.when((Object)new Boolean(this.binding.isPrimitive())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.binding.getErasure()).thenReturn((Object)this.binding);
        Mockito.when((Object)new Boolean(this.binding.isTypeVariable())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)new Boolean(this.binding.isCapture())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)new Boolean(this.binding.isWildcardType())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)new Boolean(this.binding.isAnonymous())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.resource.getProject()).thenReturn((Object)this.project);
        Mockito.when((Object)this.resource.getFileExtension()).thenReturn((Object)"java");
        Mockito.when((Object)this.binding.getJavaElement()).thenReturn((Object)this.javaElement);
        Mockito.when((Object)this.javaElement.getUnderlyingResource()).thenReturn((Object)this.resource);
        Mockito.when((Object)new Boolean(this.project.isAccessible())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.project.getAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)this.adapter);
        Mockito.when((Object)new Boolean(this.adapter.isUsusProject())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.binding.getName()).thenReturn((Object)"BindingName");
        Mockito.when((Object)this.binding.getPackage()).thenReturn((Object)this.packg);
        Mockito.when((Object)this.packg.getName()).thenReturn((Object)"PackageName");
        Mockito.when((Object)this.packg.getJavaElement()).thenReturn((Object)this.packageJavaElement);
    }

    @Test
    public void nullTypeBindingYieldsInvalidWrapper() {
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(null));
    }

    @Test
    public void primitiveTypeBindingYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.binding.isPrimitive())).thenReturn((Object)Boolean.TRUE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingYieldsInvalidWrapper() {
        Mockito.when((Object)this.binding.getErasure()).thenReturn(null);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingTypeVariableYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.binding.isTypeVariable())).thenReturn((Object)Boolean.TRUE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingCaptureYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.binding.isCapture())).thenReturn((Object)Boolean.TRUE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingWildcardTypeYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.binding.isWildcardType())).thenReturn((Object)Boolean.TRUE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingNullJavaElementYieldsInvalidWrapper() {
        Mockito.when((Object)this.binding.getJavaElement()).thenReturn(null);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingNullUnderlyingResourceYieldsInvalidWrapper() throws JavaModelException {
        Mockito.when((Object)this.javaElement.getUnderlyingResource()).thenReturn(null);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingNonJavaFileYieldsInvalidWrapper() {
        Mockito.when((Object)this.resource.getFileExtension()).thenReturn((Object)"xyz");
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingProjectNotAccessibleYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.project.isAccessible())).thenReturn((Object)Boolean.FALSE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingProjectAdapterWrongTypeYieldsInvalidWrapper() {
        Object wrongAdapter = Mockito.mock(Object.class);
        Mockito.when((Object)this.project.getAdapter((Class)Matchers.any(Class.class))).thenReturn(wrongAdapter);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingNotInUsusProjectYieldsInvalidWrapper() {
        Mockito.when((Object)new Boolean(this.adapter.isUsusProject())).thenReturn((Object)Boolean.FALSE);
        Assert.assertNull((Object)this.checker.checkForRelevanceAndWrap(this.binding));
    }

    @Test
    public void erasedBindingInUsusProjectYieldsBoundType() {
        WrappedTypeBinding boundType = this.checker.checkForRelevanceAndWrap(this.binding);
        Assert.assertNotNull((Object)boundType);
        Assert.assertEquals((Object)this.resource, (Object)boundType.getUnderlyingResource());
        Assert.assertEquals((Object)new Classname("BindingName"), (Object)boundType.getClassname());
    }
}

