/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;

public class PackageRelationsTest {
    private static Packagename I = Packagename.of("I", null);
    private static Packagename II = Packagename.of("II", null);
    private static Packagename III = Packagename.of("III", null);
    private ClassDescriptor I_A;
    private ClassDescriptor I_B;
    private ClassDescriptor II_A;
    private ClassDescriptor II_B;
    private ClassDescriptor III_A;

    @Before
    public void setup() {
        UsusModelProvider.clear();
        this.I_A = PackageRelationsTest.createDescriptor(I);
        this.I_B = PackageRelationsTest.createDescriptor(I);
        this.II_A = PackageRelationsTest.createDescriptor(II);
        this.II_B = PackageRelationsTest.createDescriptor(II);
        this.III_A = PackageRelationsTest.createDescriptor(III);
    }

    @Test
    public void crossLinkCountIsDirected() {
        this.I_A.addChild(this.II_A);
        this.I_A.addChild(this.I_B);
        this.II_A.addChild(this.II_B);
        Assert.assertEquals((long)1L, (long)this.getCrossLinkCount(I, II));
        Assert.assertEquals((long)0L, (long)this.getCrossLinkCount(II, I));
    }

    @Test
    public void noCrossLinksInsidePackages() {
        this.I_A.addChild(this.I_B);
        Assert.assertEquals((long)0L, (long)this.getCrossLinkCount(I, I));
    }

    @Test
    public void crossLinkCountAddsUp() {
        this.I_A.addChild(this.II_A);
        this.I_B.addChild(this.II_A);
        this.I_A.addChild(this.II_B);
        this.I_B.addChild(this.II_B);
        Assert.assertEquals((long)4L, (long)this.getCrossLinkCount(I, II));
    }

    @Test
    public void referencesAmongTwoClassesCountOnce() {
        this.I_A.addChild(this.II_A);
        this.I_A.addChild(this.II_A);
        Assert.assertEquals((long)1L, (long)this.getCrossLinkCount(I, II));
    }

    @Test
    public void maxLinkCount() {
        this.I_A.addChild(this.II_A);
        this.I_A.addChild(this.II_B);
        this.I_A.addChild(this.III_A);
        this.II_A.addChild(this.I_A);
        this.II_A.addChild(this.I_B);
        this.III_A.addChild(this.II_A);
        Assert.assertEquals((long)2L, (long)new PackageRelations().getMaxCrossLinkCount());
    }

    private int getCrossLinkCount(Packagename source, Packagename target) {
        return new PackageRelations().getCrossLinkCount(source, target);
    }

    private static ClassDescriptor createDescriptor(Packagename packagename) {
        return ClassDescriptor.of((IFile)Mockito.mock(IFile.class), new Classname("classname1"), packagename);
    }
}

