/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;

public class PackageCyclesTest {
    private static Packagename I = Packagename.of("I", null);
    private static Packagename II = Packagename.of("II", null);
    private static Packagename III = Packagename.of("III", null);
    private static Packagename IV = Packagename.of("IV", null);
    private ClassDescriptor I_A;
    private ClassDescriptor I_B;
    private ClassDescriptor II_A;
    private ClassDescriptor II_B;
    private ClassDescriptor III_A;
    private ClassDescriptor IV_A;

    @Before
    public void setup() {
        UsusModelProvider.clear();
        this.I_A = PackageCyclesTest.createDescriptor(I);
        this.I_B = PackageCyclesTest.createDescriptor(I);
        this.II_A = PackageCyclesTest.createDescriptor(II);
        this.II_B = PackageCyclesTest.createDescriptor(II);
        this.III_A = PackageCyclesTest.createDescriptor(III);
        this.IV_A = PackageCyclesTest.createDescriptor(IV);
    }

    @Test
    public void countPackagesInCycles1() {
        Assert.assertEquals((long)0L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles2() {
        this.I_A.addChild(this.II_A);
        Assert.assertEquals((long)0L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles3() {
        this.I_A.addChild(this.I_B);
        this.I_B.addChild(this.I_A);
        Assert.assertEquals((long)0L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles4() {
        this.I_A.addChild(this.II_A);
        this.II_A.addChild(this.I_A);
        Assert.assertEquals((long)2L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles5() {
        this.I_A.addChild(this.II_A);
        this.II_B.addChild(this.I_B);
        Assert.assertEquals((long)2L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles6() {
        this.I_A.addChild(this.II_A);
        this.II_A.addChild(this.III_A);
        this.III_A.addChild(this.I_A);
        this.IV_A.addChild(this.III_A);
        Assert.assertEquals((long)3L, (long)this.packagesInCycles());
    }

    @Test
    public void countPackagesInCycles7() {
        this.I_A.addChild(this.II_A);
        this.II_A.addChild(this.I_A);
        this.III_A.addChild(this.IV_A);
        this.IV_A.addChild(this.III_A);
        Assert.assertEquals((long)4L, (long)this.packagesInCycles());
    }

    private int packagesInCycles() {
        return new PackageRelations().getPackageCycles().numberOfPackagesInAnyCycles();
    }

    private static ClassDescriptor createDescriptor(Packagename packagename) {
        return ClassDescriptor.of((IFile)Mockito.mock(IFile.class), new Classname("classname1"), packagename);
    }
}

