/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.core.filerelations.model.Cycle;
import org.projectusus.core.filerelations.model.Packagename;

public class PackageCycleTest {
    @Test
    public void nullPackageCycle() {
        try {
            new Cycle(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (AssertionError assertionError) {
            return;
        }
        Assert.fail((String)"Cycle with null argument should throw an exception");
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPackageCycle() {
        new Cycle(new HashSet());
    }

    @Test(expected=IllegalArgumentException.class)
    public void packageCycleWith1Package() {
        HashSet<Packagename> packages = new HashSet<Packagename>();
        packages.add(Packagename.of("package1", null));
        new Cycle(packages);
    }

    @Test
    public void packageCycleWith2Packages() {
        HashSet<Packagename> packages = new HashSet<Packagename>();
        packages.add(Packagename.of("package1", null));
        packages.add(Packagename.of("package2", null));
        Cycle cycle = new Cycle(packages);
        Assert.assertEquals((long)2L, (long)cycle.numberOfElements());
    }
}

