/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import org.eclipse.core.resources.IFile;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.IntraPackageComponents;
import org.projectusus.core.filerelations.model.Packagename;

public class IntraPackageComponentsTest {
    private Packagename pkg1 = Packagename.of("pkg1", null);
    private Packagename pkg2 = Packagename.of("pkg2", null);

    @Before
    public void setup() {
        ClassDescriptor.clear();
    }

    @Test
    public void emptyPackageYieldsNoComponents() {
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(0));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(0));
    }

    @Test
    public void packageWithOneClassYieldsOneComponent() {
        this.addDescriptor("pkg");
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().values().iterator().next().size(), this.is(1));
    }

    @Test
    public void packageWithTwoUnconnectedClassesInSamePackageYieldsTwoComponents() {
        this.addDescriptor("pkg");
        this.addDescriptor("pkg");
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().values().iterator().next().size(), this.is(2));
    }

    @Test
    public void packageWithTwoConnectedClassesInSamePackageYieldsOneComponent() {
        ClassDescriptor parent = this.addDescriptor("pkg");
        ClassDescriptor child = this.addDescriptor("pkg");
        parent.addChild(child);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().values().iterator().next().size(), this.is(1));
    }

    @Test
    public void twoPackagesWithTwoUnconnectedClassesInDifferentPackagesYieldsTwoComponents() {
        this.addDescriptor(this.pkg1);
        this.addDescriptor(this.pkg2);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg1).size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg2).size(), this.is(1));
    }

    @Test
    public void twoPackagesWithTwoConnectedClassesInDifferentPackagesYieldsTwoComponents() {
        ClassDescriptor parent = this.addDescriptor(this.pkg1);
        ClassDescriptor child = this.addDescriptor(this.pkg2);
        parent.addChild(child);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg1).size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg2).size(), this.is(1));
    }

    @Test
    public void twoPackagesWithFourClassesConnectedOnlyWithinEachPackageYieldsTwoComponents() {
        ClassDescriptor p1c1 = this.addDescriptor(this.pkg1);
        ClassDescriptor p1c2 = this.addDescriptor(this.pkg1);
        p1c1.addChild(p1c2);
        ClassDescriptor p2c1 = this.addDescriptor(this.pkg2);
        ClassDescriptor p2c2 = this.addDescriptor(this.pkg2);
        p2c1.addChild(p2c2);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg1).size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg2).size(), this.is(1));
    }

    @Test
    public void twoPackagesWithFourClassesConnectedOnlyAcrossPackagesYieldsFourComponents() {
        ClassDescriptor p1c1 = this.addDescriptor(this.pkg1);
        ClassDescriptor p1c2 = this.addDescriptor(this.pkg1);
        ClassDescriptor p2c1 = this.addDescriptor(this.pkg2);
        ClassDescriptor p2c2 = this.addDescriptor(this.pkg2);
        p1c1.addChild(p2c1);
        p1c2.addChild(p2c2);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(4));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg1).size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg2).size(), this.is(2));
    }

    @Test
    public void twoPackagesWithFourClassesFullyConnectedYieldsTwoComponents() {
        ClassDescriptor p1c1 = this.addDescriptor(this.pkg1);
        ClassDescriptor p1c2 = this.addDescriptor(this.pkg1);
        ClassDescriptor p2c1 = this.addDescriptor(this.pkg2);
        ClassDescriptor p2c2 = this.addDescriptor(this.pkg2);
        p1c1.addChild(p2c1);
        p1c1.addChild(p1c2);
        p1c2.addChild(p2c2);
        p2c1.addChild(p2c2);
        this.assertThat(new IntraPackageComponents().getComponents().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().keySet().size(), this.is(2));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg1).size(), this.is(1));
        this.assertThat(new IntraPackageComponents().getSetsPerPackage().get(this.pkg2).size(), this.is(1));
    }

    private ClassDescriptor addDescriptor(String packagename) {
        return this.addDescriptor(Packagename.of(packagename, null));
    }

    private ClassDescriptor addDescriptor(Packagename pkg) {
        IFile file = (IFile)Mockito.mock(IFile.class);
        Classname classname = (Classname)Mockito.mock(Classname.class);
        return ClassDescriptor.of(file, classname, pkg);
    }

    private Matcher<Integer> is(int i) {
        return Matchers.is((Object)i);
    }

    private void assertThat(int size, Matcher<Integer> matcher) {
        Assert.assertThat((Object)size, matcher);
    }
}

