/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.test;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.CrossPackageClassRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;

public class CrossPackageClassRelationsTest {
    @Before
    public void setup() {
        UsusModelProvider.clear();
    }

    @Test
    public void emptyProject_NoCrossPackageRelations() {
        Assert.assertEquals((long)0L, (long)new CrossPackageClassRelations().getAllDirectRelations().size());
    }

    @Test
    public void oneClassInOneFile_NoCrossPackageRelations() {
        CrossPackageClassRelationsTest.createClassDescriptor("Descriptor1");
        Assert.assertEquals((long)0L, (long)new CrossPackageClassRelations().getAllDirectRelations().size());
    }

    @Test
    public void twoClassesInOnePackageKnowEachOther_NoCrossPackageRelations() {
        ClassDescriptor descriptor1 = CrossPackageClassRelationsTest.createClassDescriptorWithSamePackage("Descriptor2");
        ClassDescriptor descriptor2 = CrossPackageClassRelationsTest.createClassDescriptorWithSamePackage("Descriptor3");
        descriptor1.addChild(descriptor2);
        descriptor2.addChild(descriptor1);
        this.checkTwoNodesWithOneChildEach(ClassDescriptor.getAll());
        Assert.assertEquals((long)0L, (long)new CrossPackageClassRelations().getAllDirectRelations().size());
    }

    @Test
    public void twoClassesInTwoPackagesOneKnowsTheOther_OneCrossPackageRelation() {
        ClassDescriptor descriptor1 = CrossPackageClassRelationsTest.createClassDescriptor("Descriptor4");
        ClassDescriptor descriptor2 = CrossPackageClassRelationsTest.createClassDescriptor("Descriptor5");
        descriptor1.addChild(descriptor2);
        Set<ClassDescriptor> descriptors = ClassDescriptor.getAll();
        Assert.assertEquals((long)2L, (long)descriptors.size());
        Assert.assertEquals((long)1L, (long)descriptor1.getChildren().size());
        Assert.assertEquals((long)0L, (long)descriptor2.getChildren().size());
        Assert.assertEquals((long)1L, (long)new CrossPackageClassRelations().getAllDirectRelations().size());
    }

    @Test
    public void twoClassesInTwoPackagesKnowEachOther_TwoCrossPackageRelations() {
        ClassDescriptor descriptor1 = CrossPackageClassRelationsTest.createClassDescriptor("Descriptor6");
        ClassDescriptor descriptor2 = CrossPackageClassRelationsTest.createClassDescriptor("Descriptor7");
        descriptor1.addChild(descriptor2);
        descriptor2.addChild(descriptor1);
        this.checkTwoNodesWithOneChildEach(ClassDescriptor.getAll());
        Assert.assertEquals((long)2L, (long)new CrossPackageClassRelations().getAllDirectRelations().size());
    }

    private static ClassDescriptor createClassDescriptor(String name) {
        IFile file = (IFile)Mockito.mock(IFile.class);
        return ClassDescriptor.of(file, new Classname(name), Packagename.of(name, null));
    }

    private static ClassDescriptor createClassDescriptorWithSamePackage(String name) {
        IFile file = (IFile)Mockito.mock(IFile.class);
        return ClassDescriptor.of(file, new Classname(name), Packagename.of("packagename", null));
    }

    private void checkTwoNodesWithOneChildEach(Set<ClassDescriptor> descriptors) {
        Assert.assertEquals((long)2L, (long)descriptors.size());
        ClassDescriptor node = descriptors.iterator().next();
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = descriptors.iterator().next();
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
    }
}

