/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.classdescriptortest;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.ClassDescriptorCleanup;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.matchers.UsusMatchers;

public class FileRelationMetricsRemoveTest {
    private ClassDescriptor descriptor1;
    private ClassDescriptor descriptor2;
    private ClassDescriptor descriptor3;
    private IFile file1;
    private IFile file2;
    private IFile file3;

    @Before
    public void setupClassDescriptors() {
        this.file1 = (IFile)Mockito.mock(IFile.class);
        this.file2 = (IFile)Mockito.mock(IFile.class);
        this.file3 = (IFile)Mockito.mock(IFile.class);
    }

    public static ClassDescriptor createClassDescriptor(IFile file, String name) {
        return ClassDescriptor.of(file, new Classname(name), Packagename.of(name, null));
    }

    @Test
    public void mocksAreNotEqual() {
        Assert.assertFalse((boolean)this.file1.equals((Object)this.file2));
    }

    @Test
    public void noRelations() {
        this.setupOneWithOneFile();
        this.descriptor1.prepareRemoval();
        Assert.assertEquals((long)1L, (long)ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup().size());
    }

    @Test
    public void oneRelationSameFile() {
        this.setupTwoWithOneFile();
        this.descriptor1.prepareRemoval();
        this.descriptor2.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertEquals((long)2L, (long)ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup().size());
    }

    @Test
    public void oneRelationDifferentFilesRemoveSource() {
        this.setupTwoWithTwoFiles();
        this.descriptor1.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertEquals((long)1L, (long)ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup().size());
    }

    @Test
    public void oneRelationDifferentFilesRemoveTarget() {
        this.setupTwoWithTwoFiles();
        this.descriptor2.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        this.checkRelationsToRepair(this.descriptor1, this.descriptor2);
    }

    @Test
    public void twoRelationsOneFile() {
        this.setupThreeWithOneFile();
        this.descriptor1.prepareRemoval();
        this.descriptor2.prepareRemoval();
        this.descriptor3.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertEquals((long)3L, (long)ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup().size());
    }

    @Test
    public void twoRelationsThreeFilesRemoveFirst() {
        this.setupThreeWithThreeFiles();
        this.descriptor1.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor3}));
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertEquals((long)1L, (long)ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup().size());
    }

    @Test
    public void twoRelationsThreeFilesRemoveSecond() {
        this.setupThreeWithThreeFiles();
        this.descriptor2.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
        this.checkRelationsToRepair(this.descriptor1, this.descriptor2);
    }

    @Test
    public void twoRelationsThreeFilesRemoveThird() {
        this.setupThreeWithThreeFiles();
        this.descriptor3.prepareRemoval();
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor3}));
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
        this.checkRelationsToRepair(this.descriptor2, this.descriptor3);
    }

    private void setupOneWithOneFile() {
        this.descriptor1 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor1");
    }

    private void setupTwoWithOneFile() {
        this.descriptor1 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor1");
        this.descriptor2 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor2");
        this.descriptor1.addChild(this.descriptor2);
    }

    private void setupTwoWithTwoFiles() {
        this.descriptor1 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor1");
        this.descriptor2 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file2, "Descriptor2");
        this.descriptor1.addChild(this.descriptor2);
    }

    private void setupThreeWithOneFile() {
        this.descriptor1 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor1");
        this.descriptor2 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor2");
        this.descriptor3 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor3");
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
    }

    private void setupThreeWithThreeFiles() {
        this.descriptor1 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file1, "Descriptor1");
        this.descriptor2 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file2, "Descriptor2");
        this.descriptor3 = FileRelationMetricsRemoveTest.createClassDescriptor(this.file3, "Descriptor3");
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
    }

    private void checkRelationsToRepair(ClassDescriptor source, ClassDescriptor target) {
        Set<ClassDescriptor> descriptorsForCleanup = ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup();
        Assert.assertEquals((long)1L, (long)descriptorsForCleanup.size());
        for (ClassDescriptor descriptor : descriptorsForCleanup) {
            Assert.assertEquals((Object)target, (Object)descriptor);
            descriptor.removeFromPool();
        }
        Assert.assertThat(source.getChildren(), (Matcher)UsusMatchers.emptySet());
    }
}

