/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.classdescriptortest;

import org.eclipse.core.resources.IFile;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;

public class ClassDescriptorTest {
    private static final String NAME_STRING = "name";
    private static final String PACKAGENAME_STRING = "packagename";
    private Classname classname1 = new Classname("name");
    private Classname classname2 = new Classname("name");
    private Packagename packagename1 = Packagename.of("packagename", null);
    private Packagename packagename2 = Packagename.of("packagename", null);
    private IFile file;

    @Before
    public void setup() {
        this.file = (IFile)Mockito.mock(IFile.class);
    }

    @Test
    public void equalsIsEqual() {
        ClassDescriptor descriptor1 = ClassDescriptorTest.createDescriptor(this.file);
        ClassDescriptor descriptor2 = ClassDescriptorTest.createDescriptor(this.file);
        Assert.assertTrue((boolean)descriptor1.equals((Object)descriptor2));
        Assert.assertSame((Object)descriptor1, (Object)descriptor2);
    }

    @Test
    public void differentClassDescriptorsWithEqualContentsAreEqualAndSame() {
        ClassDescriptor descriptor1a = ClassDescriptor.of(this.file, this.classname1, this.packagename1);
        ClassDescriptor descriptor1b = ClassDescriptor.of(this.file, this.classname1, this.packagename1);
        ClassDescriptor descriptor2 = ClassDescriptor.of(this.file, this.classname2, this.packagename2);
        Assert.assertEquals((Object)descriptor1a, (Object)descriptor2);
        Assert.assertEquals((Object)descriptor1a, (Object)descriptor1b);
        Assert.assertEquals((Object)descriptor1b, (Object)descriptor2);
        Assert.assertSame((Object)descriptor1a, (Object)descriptor2);
        Assert.assertSame((Object)descriptor1a, (Object)descriptor1b);
        Assert.assertSame((Object)descriptor1b, (Object)descriptor2);
    }

    @Test
    public void classIsAddedToPackageOnCreation() {
        ClassDescriptor descriptor = ClassDescriptorTest.createDescriptor(this.file);
        Assert.assertTrue((boolean)descriptor.getPackagename().containsClass(descriptor));
    }

    @Test
    public void classIsRemovedFromPackageOnDestruction() {
        ClassDescriptor descriptor = ClassDescriptorTest.createDescriptor(this.file);
        Packagename packagename = descriptor.getPackagename();
        descriptor.removeFromPool();
        Assert.assertFalse((boolean)packagename.containsClass(descriptor));
    }

    @Test
    public void isCrossPackage() {
        ClassDescriptor first = ClassDescriptorTest.createDescriptor(Packagename.of("x", null));
        ClassDescriptor second = ClassDescriptorTest.createDescriptor(Packagename.of("y", null));
        first.addChild(second);
        Assert.assertThat(first.getChildrenInOtherPackages(), (Matcher)Matchers.hasItems((Object[])new ClassDescriptor[]{second}));
    }

    @Test
    public void classIsNotAddedToItsChildren() {
        ClassDescriptor descriptor = ClassDescriptor.of((IFile)Mockito.mock(IFile.class), new Classname("classname"), Packagename.of(NAME_STRING, null));
        Assert.assertEquals((long)0L, (long)descriptor.getChildren().size());
        descriptor.addChild(descriptor);
        Assert.assertEquals((long)0L, (long)descriptor.getChildren().size());
    }

    private static ClassDescriptor createDescriptor(IFile file) {
        return ClassDescriptor.of(file, new Classname("classname1"), Packagename.of("packagename1", null));
    }

    private static ClassDescriptor createDescriptor(Packagename packagename) {
        return ClassDescriptor.of((IFile)Mockito.mock(IFile.class), new Classname("classname1"), packagename);
    }
}

