/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.classdescriptortest;

import org.eclipse.core.resources.IFile;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.matchers.UsusMatchers;

public class ClassDescriptorGetChildrenTest {
    private ClassDescriptor descriptor1;
    private ClassDescriptor descriptor2;
    private ClassDescriptor descriptor3;

    @Before
    public void setupClassDescriptors() {
        this.descriptor1 = ClassDescriptorGetChildrenTest.createClassDescriptor("Descriptor1");
        this.descriptor2 = ClassDescriptorGetChildrenTest.createClassDescriptor("Descriptor2");
        this.descriptor3 = ClassDescriptorGetChildrenTest.createClassDescriptor("Descriptor3");
    }

    public static ClassDescriptor createClassDescriptor(String name) {
        IFile file = (IFile)Mockito.mock(IFile.class);
        return ClassDescriptor.of(file, new Classname(name), Packagename.of(name, null));
    }

    @Test
    public void noRelations() {
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.emptySet());
    }

    @Test
    public void oneRelation() {
        this.descriptor1.addChild(this.descriptor2);
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
    }

    @Test
    public void oneClassKnows2() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor1.addChild(this.descriptor3);
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2, this.descriptor3}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.emptySet());
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
    }

    @Test
    public void oneClassKnows1Knows1() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor3}));
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.emptySet());
    }

    @Test
    public void threeClassCycle() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor1);
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor3}));
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor1}));
    }

    @Test
    public void threeClasses2InCycle() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor2);
        Assert.assertThat(this.descriptor1.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
        Assert.assertThat(this.descriptor2.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor3}));
        Assert.assertThat(this.descriptor3.getChildren(), (Matcher)UsusMatchers.setOf((Object[])new ClassDescriptor[]{this.descriptor2}));
    }
}

