/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.classdescriptortest;

import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;

public class CCDTest {
    private ClassDescriptor descriptor1;
    private ClassDescriptor descriptor2;
    private ClassDescriptor descriptor3;

    @Before
    public void setupClassDescriptors() {
        UsusModelProvider.clear();
        this.descriptor1 = CCDTest.createClassDescriptor("Descriptor1");
        this.descriptor2 = CCDTest.createClassDescriptor("Descriptor2");
        this.descriptor3 = CCDTest.createClassDescriptor("Descriptor3");
    }

    public static ClassDescriptor createClassDescriptor(String name) {
        IFile file = (IFile)Mockito.mock(IFile.class);
        return ClassDescriptor.of(file, new Classname(name), Packagename.of(name, null));
    }

    @Test
    public void noRelations() {
        Assert.assertEquals((long)1L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void oneRelation() {
        this.descriptor1.addChild(this.descriptor2);
        Assert.assertEquals((long)2L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor2.getCCD());
    }

    @Test
    public void oneClassKnows2() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor1.addChild(this.descriptor3);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void oneClassKnows1Knows1() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)2L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void twoClassCycle() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor1);
        Assert.assertEquals((long)2L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)2L, (long)this.descriptor2.getCCD());
    }

    @Test
    public void threeClassCycle() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor1);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void threeClasses2InCycle() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor2);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)2L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)2L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void transitiveChildrenWithSelfLoop() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)2L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)1L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void calculateManyRelations() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor1.addChild(this.descriptor3);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor2);
        this.descriptor3.addChild(this.descriptor1);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void transitiveRelationsFromCyclicRelationsIncludingStart() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor2);
        this.descriptor3.addChild(this.descriptor1);
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor3.getCCD());
    }

    @Test
    public void secondQueryingOfCCDYieldsTheSameResult() {
        this.descriptor1.addChild(this.descriptor2);
        this.descriptor2.addChild(this.descriptor3);
        this.descriptor3.addChild(this.descriptor2);
        this.descriptor3.addChild(this.descriptor1);
        this.descriptor1.getCCD();
        this.descriptor2.getCCD();
        this.descriptor3.getCCD();
        Assert.assertEquals((long)3L, (long)this.descriptor1.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor2.getCCD());
        Assert.assertEquals((long)3L, (long)this.descriptor3.getCCD());
    }
}

