/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model.classdescriptortest;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.ClassDescriptorCleanup;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;

public class AdditionAndRemovalOfClassDescriptorsTest {
    private IFile file = (IFile)Mockito.mock(IFile.class);
    private Packagename packagename = Packagename.of("packagename", null);
    private Classname classname1 = new Classname("Name1");
    private Classname classname2 = new Classname("Name2");
    private Classname classname3 = new Classname("Name3");

    @Before
    public void init() {
        UsusModelProvider.clear();
    }

    @Test
    public void oneClassDescriptorNoRelations() {
        this.classDescriptorOf(this.classname1);
        Assert.assertEquals((long)1L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void twoClassDescriptorsOneRelation() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor target = this.classDescriptorOf(this.classname2);
        source.addChild(target);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void threeClassDescriptorsTwoRelations() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle = this.classDescriptorOf(this.classname2);
        source.addChild(middle);
        ClassDescriptor target = this.classDescriptorOf(this.classname3);
        middle.addChild(target);
        Assert.assertEquals((long)3L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void threeClassDescriptorsTwoRelationsFirstAndSecondRemovedInBetween() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle = this.classDescriptorOf(this.classname2);
        source.addChild(middle);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        source.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)1L, (long)ClassDescriptor.getAll().size());
        middle.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)0L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor source2 = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle2 = this.classDescriptorOf(this.classname2);
        source2.addChild(middle2);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor target = this.classDescriptorOf(this.classname3);
        middle2.addChild(target);
        Assert.assertEquals((long)3L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void threeClassDescriptorsTwoRelationsSecondAndFirstRemovedInBetween() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle = this.classDescriptorOf(this.classname2);
        source.addChild(middle);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        middle.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)1L, (long)ClassDescriptor.getAll().size());
        source.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)0L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor source2 = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle2 = this.classDescriptorOf(this.classname2);
        source2.addChild(middle2);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor target = this.classDescriptorOf(this.classname3);
        middle2.addChild(target);
        Assert.assertEquals((long)3L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void threeClassDescriptorsTwoRelationsSecondRemovedInBetween() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor middle = this.classDescriptorOf(this.classname2);
        source.addChild(middle);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        middle.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)1L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor middle2 = this.classDescriptorOf(this.classname2);
        source.addChild(middle2);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        ClassDescriptor target = this.classDescriptorOf(this.classname3);
        middle2.addChild(target);
        Assert.assertEquals((long)3L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void twoClassDescriptorsOneRelationRemoved() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor target = this.classDescriptorOf(this.classname2);
        source.addChild(target);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        target.prepareRemoval();
        this.cleanupDescriptors(1);
        Assert.assertEquals((long)1L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void twoClassDescriptorsOneRelationBothRemovedSourceFirst() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor target = this.classDescriptorOf(this.classname2);
        source.addChild(target);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        source.prepareRemoval();
        target.prepareRemoval();
        this.cleanupDescriptors(2);
        Assert.assertEquals((long)0L, (long)ClassDescriptor.getAll().size());
    }

    @Test
    public void twoClassDescriptorsOneRelationBothRemovedTargetFirst() {
        ClassDescriptor source = this.classDescriptorOf(this.classname1);
        ClassDescriptor target = this.classDescriptorOf(this.classname2);
        source.addChild(target);
        Assert.assertEquals((long)2L, (long)ClassDescriptor.getAll().size());
        target.prepareRemoval();
        source.prepareRemoval();
        this.cleanupDescriptors(2);
        Assert.assertEquals((long)0L, (long)ClassDescriptor.getAll().size());
    }

    private ClassDescriptor classDescriptorOf(Classname classname22) {
        return ClassDescriptor.of(this.file, classname22, this.packagename);
    }

    private void cleanupDescriptors(int count) {
        Set<ClassDescriptor> descriptorsForCleanup = ClassDescriptorCleanup.extractDescriptorsRegisteredForCleanup();
        Assert.assertEquals((long)count, (long)descriptorsForCleanup.size());
        for (ClassDescriptor descriptor : descriptorsForCleanup) {
            descriptor.removeFromPool();
        }
    }
}

