/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.project2.UsusProjectSupport;

public class TypeBindingChecker {
    private static final String JAVA_FILE_EXTENSION = "java";

    public WrappedTypeBinding checkForRelevanceAndWrap(ITypeBinding typeBinding) {
        ITypeBinding relevantBinding = this.findRelevantBinding(typeBinding);
        IFile underlyingResource = this.checkUnderlyingResource(relevantBinding);
        if (relevantBinding != null && underlyingResource != null) {
            return new WrappedTypeBinding(underlyingResource, relevantBinding);
        }
        return null;
    }

    private ITypeBinding findRelevantBinding(ITypeBinding typeBinding) {
        ITypeBinding binding = typeBinding;
        if (binding == null || binding.isPrimitive()) {
            return null;
        }
        if ((binding = binding.getErasure()) == null || binding.isPrimitive()) {
            return null;
        }
        if (binding.isTypeVariable() || binding.isCapture() || binding.isWildcardType()) {
            return null;
        }
        if (binding.isAnonymous()) {
            return this.findRelevantBinding(binding.getDeclaringClass());
        }
        return binding;
    }

    private IFile checkUnderlyingResource(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        try {
            IFile resource = (IFile)binding.getJavaElement().getUnderlyingResource();
            if (this.isJavaFile(resource) && this.isInsideUsusProject(resource)) {
                return resource;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private boolean isInsideUsusProject(IFile underlyingResource) {
        return UsusProjectSupport.asUsusProject(underlyingResource.getProject()).isUsusProject();
    }

    private boolean isJavaFile(IFile underlyingResource) {
        return underlyingResource != null && underlyingResource.getFileExtension().equals(JAVA_FILE_EXTENSION);
    }
}

