/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.Collection;
import java.util.Set;
import org.projectusus.c4j.UsusContractBase;
import org.projectusus.core.filerelations.model.Relation;
import org.projectusus.core.filerelations.model.Relations;

public class RelationsContract<K>
extends UsusContractBase<Relations<K>> {
    private String targetString() {
        return " Meth-Target: " + this.m_target;
    }

    public RelationsContract(Relations<K> target) {
        super(target);
    }

    public void classInvariant() {
        for (Relation relation : ((Relations)this.m_target).getAllDirectRelations()) {
            this.assertThat(((Relations)this.m_target).getDirectRelationsFrom(relation.getSource()).contains(relation), "Each relation is in the relations-from set" + this.targetString());
            this.assertThat(((Relations)this.m_target).getDirectRelationsTo(relation.getTarget()).contains(relation), "Each relation is in the relations-to set" + this.targetString());
        }
    }

    public void pre_Relations() {
    }

    public void post_Relations() {
    }

    public void pre_getDirectRelationsFrom(K sourceFile) {
        this.assertThat(sourceFile != null, "sourceFile_not_null" + this.targetString());
    }

    public void post_getDirectRelationsFrom(K sourceFile) {
        Set returnValue = (Set)RelationsContract.getReturnValue();
        for (Relation relation : returnValue) {
            this.assertThat(relation.getSource().equals(sourceFile), "Method argument is source of all returned relations" + this.targetString());
        }
        if (!((Relations)this.m_target).containsKey(sourceFile)) {
            this.assertThat(returnValue.isEmpty(), "No direct relations when method argument is not in key list" + this.targetString());
        }
    }

    public void pre_getDirectRelationsTo(K targetFile) {
        this.assertThat(targetFile != null, "targetFile_not_null");
    }

    public void post_getDirectRelationsTo(K targetFile) {
        Set returnValue = (Set)RelationsContract.getReturnValue();
        for (Relation relation : returnValue) {
            this.assertThat(relation.getTarget().equals(targetFile), "Method argument is target of all returned relations" + this.targetString());
        }
        if (!((Relations)this.m_target).containsKey(targetFile)) {
            this.assertThat(returnValue.isEmpty(), "No direct relations when method argument is not in key list" + this.targetString());
        }
    }

    public void pre_removeDirectRelationsFrom(K sourceFile) {
        this.assertThat(sourceFile != null, "sourceFile_not_null" + this.targetString());
    }

    public void post_removeDirectRelationsFrom(K sourceFile) {
        this.assertThat(((Relations)this.m_target).getDirectRelationsFrom(sourceFile).isEmpty(), "No direct relations from method argument are available" + this.targetString());
        for (Relation relation : ((Relations)this.m_target).getAllDirectRelations()) {
            this.assertThat(!relation.getSource().equals(sourceFile), "No direct relations have method argument as source" + this.targetString());
        }
    }

    public void pre_getAllDirectRelations() {
    }

    public void post_getAllDirectRelations() {
        Collection cfr_ignored_0 = (Collection)RelationsContract.getReturnValue();
    }

    public void pre_remove(K sourceKey, K targetKey) {
        this.assertThat(sourceKey != null, "sourceKey_not_null" + this.targetString());
        this.assertThat(targetKey != null, "targetKey_not_null" + this.targetString());
    }

    public void post_remove(K sourceKey, K targetKey) {
        for (Relation<K> relation : ((Relations)this.m_target).getDirectRelationsFrom(sourceKey)) {
            this.assertThat(!relation.getTarget().equals(targetKey), "Relations from removed source do not contain relations to removed target" + this.targetString());
        }
        for (Relation<K> relation : ((Relations)this.m_target).getDirectRelationsTo(targetKey)) {
            this.assertThat(!relation.getSource().equals(sourceKey), "Relations to removed target do not contain relations from removed source" + this.targetString());
        }
    }

    public void pre_containsKey(K key) {
        this.assertThat(key != null, "key_not_null" + this.targetString());
    }

    public void post_containsKey(K key) {
        boolean returnValue = (Boolean)RelationsContract.getReturnValue();
        this.assertThat(returnValue == ((Relations)this.m_target).keySet().contains(key), "Relations contains key iff keyset contains key" + this.targetString());
    }

    public void pre_keySet() {
    }

    public void post_keySet() {
        Set cfr_ignored_0 = (Set)RelationsContract.getReturnValue();
    }
}

