/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.c4j.ContractReference;
import org.projectusus.core.filerelations.model.Relation;

@ContractReference(contractClassName="RelationsContract")
public class Relations<K> {
    protected final Multimap<K, Relation<K>> incomingRelations = ArrayListMultimap.create();
    protected final Multimap<K, Relation<K>> outgoingRelations = ArrayListMultimap.create();

    public Set<Relation<K>> getDirectRelationsFrom(K sourceFile) {
        return this.getAsSet(this.outgoingRelations.get(sourceFile));
    }

    public Set<Relation<K>> getDirectRelationsTo(K targetFile) {
        return this.getAsSet(this.incomingRelations.get(targetFile));
    }

    public void removeDirectRelationsFrom(K sourceFile) {
        this.outgoingRelations.removeAll(sourceFile);
    }

    public Collection<Relation<K>> getAllDirectRelations() {
        return Collections.unmodifiableSet(this.getAsSet(this.outgoingRelations.values()));
    }

    protected void add(K sourceKey, K targetKey) {
        Relation<K> relation = new Relation<K>(sourceKey, targetKey);
        this.outgoingRelations.put(sourceKey, relation);
        this.incomingRelations.put(targetKey, relation);
    }

    public void remove(K sourceKey, K targetKey) {
        Relation<K> relation = new Relation<K>(sourceKey, targetKey);
        this.outgoingRelations.remove(sourceKey, relation);
        this.incomingRelations.remove(targetKey, relation);
    }

    public boolean containsKey(K key) {
        return this.outgoingRelations.containsKey(key) || this.incomingRelations.containsKey(key);
    }

    public Set<K> keySet() {
        return Sets.union((Set)this.outgoingRelations.keySet(), (Set)this.incomingRelations.keySet());
    }

    protected Collection<Relation<K>> getAllOutgoingRelationsFrom(K key) {
        return this.outgoingRelations.get(key);
    }

    protected Collection<Relation<K>> getAllIncomingRelationsTo(K key) {
        return this.incomingRelations.get(key);
    }

    private HashSet<Relation<K>> getAsSet(Collection<Relation<K>> collection) {
        return Sets.newHashSet(collection);
    }
}

