/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.projectusus.core.filerelations.model.Relation;
import org.projectusus.core.filerelations.model.Relations;
import org.projectusus.core.filerelations.model.UnmodifiableDirectedGraph;

public class RelationGraph<T>
extends UnmodifiableDirectedGraph<T, Relation<T>> {
    private final Relations<T> relations;

    public RelationGraph(Relations<T> relations) {
        this.relations = relations;
    }

    public Set<Relation<T>> incomingEdgesOf(T vertex) {
        return this.relations.getDirectRelationsTo(vertex);
    }

    public Set<Relation<T>> outgoingEdgesOf(T vertex) {
        return this.relations.getDirectRelationsFrom(vertex);
    }

    public boolean containsVertex(T vertex) {
        return this.relations.containsKey(vertex);
    }

    public Set<Relation<T>> edgeSet() {
        return new HashSet<Relation<T>>(this.relations.getAllDirectRelations());
    }

    public Set<Relation<T>> getAllEdges(T source, T target) {
        Object relation = this.getEdge((Object)source, (Object)target);
        Set emptySet = Collections.emptySet();
        return relation == null ? emptySet : Collections.singleton(relation);
    }

    public Relation<T> getEdge(T source, T target) {
        Relation<T> searchedForRelation = new Relation<T>(source, target);
        for (Relation<T> relation : this.outgoingEdgesOf(source)) {
            if (!searchedForRelation.equals((Object)relation)) continue;
            return relation;
        }
        return null;
    }

    public EdgeFactory<T, Relation<T>> getEdgeFactory() {
        return new EdgeFactory<T, Relation<T>>(){

            public Relation<T> createEdge(T source, T target) {
                return new Relation(source, target);
            }
        };
    }

    public T getEdgeSource(Relation<T> relation) {
        return relation.getSource();
    }

    public T getEdgeTarget(Relation<T> relation) {
        return relation.getTarget();
    }

    public Set<T> vertexSet() {
        return this.relations.keySet();
    }
}

