/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import com.google.common.base.Function;
import net.sourceforge.c4j.ContractReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@ContractReference(contractClassName="RelationContract")
public class Relation<T> {
    protected final T source;
    protected final T target;

    public Relation(T source, T target) {
        this.source = source;
        this.target = target;
    }

    public T getSource() {
        return this.source;
    }

    public T getTarget() {
        return this.target;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.source);
        builder.append(this.target);
        return builder.toHashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Relation && this.equals((Relation)object);
    }

    private boolean equals(Relation<T> other) {
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.source, other.source);
        builder.append(this.target, other.target);
        return builder.isEquals();
    }

    public String toString() {
        return this.source + " -> " + this.target;
    }

    public static final <T> Function<Relation<T>, T> target() {
        return new Function<Relation<T>, T>(){

            public T apply(Relation<T> input) {
                return input.target;
            }
        };
    }
}

