/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.projectusus.c4j.C4JFileWriter;
import org.projectusus.c4j.UsusContractBase;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.Relation;

public class PackagenameContract
extends UsusContractBase<Packagename> {
    private int numberOfClasses;
    private boolean packageContainsClass;

    private String targetString() {
        return " Target: " + this.m_target;
    }

    public PackagenameContract(Packagename target) {
        super(target);
    }

    public void classInvariant() {
        this.assertThat(Packagename.getAll().contains(this.m_target), "CONTRADICTION?! Element is contained in list of all:" + this.targetString());
    }

    public static void pre_clear() {
    }

    public static void post_clear() {
        C4JFileWriter.assertStatic(Packagename.getAll().isEmpty(), "Clear removes all Packagename objects.");
    }

    public static void pre_of(String name, IJavaElement javaElement) {
        C4JFileWriter.assertStatic(name != null, "name_not_null");
        C4JFileWriter.assertStatic(javaElement != null, "javaElement_not_null");
    }

    public static void post_of(String name, IJavaElement javaElement) {
        Packagename returnValue = (Packagename)PackagenameContract.getReturnValue();
        C4JFileWriter.assertStatic(Packagename.getAll().contains(returnValue), "List of all contains Packagename " + returnValue);
    }

    public static void pre_getAll() {
    }

    public static void post_getAll() {
        Set cfr_ignored_0 = (Set)PackagenameContract.getReturnValue();
    }

    public void pre_addClass(ClassDescriptor clazz) {
        this.assertThat(clazz != null, "clazz_not_null");
        this.numberOfClasses = ((Packagename)this.m_target).numberOfClasses();
        this.packageContainsClass = ((Packagename)this.m_target).containsClass(clazz);
    }

    public void post_addClass(ClassDescriptor clazz) {
        if (this.packageContainsClass) {
            this.assertThat(this.numberOfClasses == ((Packagename)this.m_target).numberOfClasses(), "Adding an already contained class does not change the class count for " + this.targetString());
        } else {
            this.assertThat(this.numberOfClasses + 1 == ((Packagename)this.m_target).numberOfClasses(), "Adding an unknown class increases the class count by 1 for " + this.targetString());
        }
        this.assertThat(((Packagename)this.m_target).containsClass(clazz), "Added class is now contained in package " + this.targetString());
    }

    public void pre_removeClass(ClassDescriptor clazz) {
        this.assertThat(clazz != null, "clazz_not_null");
        this.numberOfClasses = ((Packagename)this.m_target).numberOfClasses();
    }

    public void post_removeClass(ClassDescriptor clazz) {
        this.assertThat(this.numberOfClasses - 1 == ((Packagename)this.m_target).numberOfClasses(), "Removing a class reduces the class count by 1 for " + this.targetString());
        this.assertThat(!((Packagename)this.m_target).containsClass(clazz), "Removed class is no longer contained in package" + this.targetString());
        if (((Packagename)this.m_target).numberOfClasses() == 0) {
            this.assertThat(!Packagename.getAll().contains(this.m_target), "CONTRADICTION?! Packages w/o classes are removed from list" + this.targetString());
        }
    }

    public void pre_containsClass(ClassDescriptor clazz) {
        this.assertThat(clazz != null, "clazz_not_null");
    }

    public void post_containsClass(ClassDescriptor clazz) {
        ((Boolean)PackagenameContract.getReturnValue()).booleanValue();
    }

    public void pre_numberOfClasses() {
    }

    public void post_numberOfClasses() {
        ((Integer)PackagenameContract.getReturnValue()).intValue();
    }

    public void pre_getJavaElement() {
    }

    public void post_getJavaElement() {
        IJavaElement cfr_ignored_0 = (IJavaElement)PackagenameContract.getReturnValue();
    }

    public void pre_getRelationTo(Packagename target) {
        this.assertThat(target != null, "target_not_null");
    }

    public void post_getRelationTo(Packagename target) {
        Relation cfr_ignored_0 = (Relation)PackagenameContract.getReturnValue();
    }
}

