/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.c4j.ContractReference;
import org.eclipse.jdt.core.IJavaElement;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Relation;

@ContractReference(contractClassName="PackagenameContract")
public class Packagename {
    private static Map<String, Packagename> allPackages = new HashMap<String, Packagename>();
    public static final String COLOR_PREFIX = "PACKAGE";
    private String name;
    private Set<ClassDescriptor> classesInPackage = new HashSet<ClassDescriptor>();
    private final IJavaElement javaElement;

    public static void clear() {
        allPackages = new HashMap<String, Packagename>();
    }

    public static Packagename of(String name, IJavaElement javaElement) {
        if (allPackages.containsKey(name)) {
            return allPackages.get(name);
        }
        Packagename newPackage = new Packagename(name, javaElement);
        allPackages.put(name, newPackage);
        return newPackage;
    }

    public static Set<Packagename> getAll() {
        return new HashSet<Packagename>(allPackages.values());
    }

    private Packagename(String name, IJavaElement javaElement) {
        this.name = name;
        this.javaElement = javaElement;
    }

    public void addClass(ClassDescriptor clazz) {
        this.classesInPackage.add(clazz);
    }

    public void removeClass(ClassDescriptor clazz) {
        this.classesInPackage.remove(clazz);
        if (this.classesInPackage.isEmpty()) {
            allPackages.remove(this.name);
        }
    }

    public boolean containsClass(ClassDescriptor clazz) {
        return this.classesInPackage.contains(clazz);
    }

    public int numberOfClasses() {
        return this.classesInPackage.size();
    }

    public boolean equals(Object obj) {
        return obj instanceof Packagename && this.name.equals(((Packagename)obj).name);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public Relation<Packagename> getRelationTo(Packagename target) {
        return new Relation<Packagename>(this, target);
    }

    public String getDisplayName() {
        return this.getJavaElement().getElementName();
    }

    public String getOSPath() {
        return this.getJavaElement().getPath().toOSString();
    }

    public Set<ClassDescriptor> getClassesInPackage() {
        return Collections.unmodifiableSet(this.classesInPackage);
    }
}

