/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.PackageCycles;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.Relation;
import org.projectusus.core.filerelations.model.RelationGraph;
import org.projectusus.core.filerelations.model.Relations;

public class PackageRelations
extends Relations<Packagename> {
    private PackageCycles packageCycles;
    private int maxLinkCount = -1;

    public PackageRelations() {
        this.calcPackageRelations((Predicate<Packagename>)Predicates.alwaysTrue());
        this.calcPackageCycles();
    }

    public PackageRelations(Predicate<Packagename> isVisible) {
        this.calcPackageRelations(isVisible);
        this.calcPackageCycles();
    }

    public void calcPackageRelations(Predicate<Packagename> isVisible) {
        for (ClassDescriptor source : ClassDescriptor.getAll()) {
            for (ClassDescriptor target : source.getChildrenInOtherPackages()) {
                if (!isVisible.apply((Object)source.getPackagename()) || !isVisible.apply((Object)target.getPackagename())) continue;
                this.add(source.getPackagename(), target.getPackagename());
            }
        }
    }

    private void calcPackageCycles() {
        RelationGraph<Packagename> graph = new RelationGraph<Packagename>(this);
        StrongConnectivityInspector inspector = new StrongConnectivityInspector(graph);
        this.packageCycles = new PackageCycles(inspector.stronglyConnectedSets());
    }

    public Set<Packagename> getDirectPackageRelationsFrom(Packagename packagename) {
        HashSet<Packagename> descriptors = new HashSet<Packagename>();
        for (Relation<Packagename> relation : this.getDirectRelationsFrom(packagename)) {
            descriptors.add(relation.getTarget());
        }
        return descriptors;
    }

    public Set<Packagename> getDirectPackageRelationsTo(Packagename packagename) {
        HashSet<Packagename> descriptors = new HashSet<Packagename>();
        for (Relation<Packagename> relation : this.getDirectRelationsTo(packagename)) {
            descriptors.add(relation.getSource());
        }
        return descriptors;
    }

    public PackageCycles getPackageCycles() {
        return this.packageCycles;
    }

    public int getCrossLinkCount(Packagename source, Packagename target) {
        int crossLinkCount = 0;
        Collection<Relation<Packagename>> relationsFromSource = this.getAllOutgoingRelationsFrom(source);
        for (Relation<Packagename> relation : relationsFromSource) {
            if (!relation.getTarget().equals(target)) continue;
            ++crossLinkCount;
        }
        return crossLinkCount;
    }

    public int getMaxCrossLinkCount() {
        if (this.maxCrossLinkCountCached()) {
            return this.maxLinkCount;
        }
        for (Packagename sourcePackage : this.outgoingRelations.keys()) {
            this.maxLinkCount = Math.max(this.maxLinkCount, this.calculateMaxLinkCountForPackage(sourcePackage));
        }
        return this.maxLinkCount;
    }

    private boolean maxCrossLinkCountCached() {
        return this.maxLinkCount > -1;
    }

    private int calculateMaxLinkCountForPackage(Packagename sourcePackage) {
        ImmutableListMultimap groupedLinks = Multimaps.index((Iterable)this.outgoingRelations.get((Object)sourcePackage), Relation.target());
        Packagename mostTargetedPackage = this.findMostTargetedPackage((Multimap<Packagename, Relation<Packagename>>)groupedLinks);
        int maxNumberOfRelations = groupedLinks.get((Object)mostTargetedPackage).size();
        return maxNumberOfRelations;
    }

    private Packagename findMostTargetedPackage(Multimap<Packagename, Relation<Packagename>> linksByPackage) {
        ArrayList entries = new ArrayList(linksByPackage.entries());
        Packagename mostTargetedPackage = Collections.max(entries, this.mapValuesComparator(linksByPackage)).getKey();
        return mostTargetedPackage;
    }

    private Comparator<Map.Entry<Packagename, Relation<Packagename>>> mapValuesComparator(final Multimap<Packagename, Relation<Packagename>> linksByPackage) {
        return new Comparator<Map.Entry<Packagename, Relation<Packagename>>>(){

            @Override
            public int compare(Map.Entry<Packagename, Relation<Packagename>> e1, Map.Entry<Packagename, Relation<Packagename>> e2) {
                Collection relationsToPackage1 = linksByPackage.get((Object)e1.getKey());
                Collection relationsToPackage2 = linksByPackage.get((Object)e2.getKey());
                return Ints.compare((int)relationsToPackage1.size(), (int)relationsToPackage2.size());
            }
        };
    }
}

