/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.projectusus.core.filerelations.model.Cycle;
import org.projectusus.core.filerelations.model.Packagename;

public class PackageCycles {
    private final List<Cycle<Packagename>> packageCycles = new ArrayList<Cycle<Packagename>>();

    public PackageCycles(List<Set<Packagename>> cycles) {
        for (Set<Packagename> cycle : cycles) {
            if (cycle.size() <= 1) continue;
            this.packageCycles.add(new Cycle<Packagename>(cycle));
        }
    }

    public int numberOfPackagesInAnyCycles() {
        int count = 0;
        for (Cycle<Packagename> cycle : this.packageCycles) {
            count += cycle.numberOfElements();
        }
        return count;
    }

    public boolean containsPackage(Packagename packagename) {
        for (Cycle<Packagename> cycle : this.packageCycles) {
            if (!cycle.contains(packagename)) continue;
            return true;
        }
        return false;
    }

    public List<Cycle<Packagename>> getPackageCycles() {
        return this.packageCycles;
    }
}

