/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import ch.akuhn.foreach.ForEach;
import ch.akuhn.foreach.GroupBy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.Relation;
import org.projectusus.core.filerelations.model.RelationFactory;

public class IntraPackageComponents {
    public List<Set<ClassDescriptor>> getComponents() {
        DirectedGraph<ClassDescriptor, Relation<ClassDescriptor>> graph = this.calcGraph();
        ConnectivityInspector inspector = new ConnectivityInspector(graph);
        return inspector.connectedSets();
    }

    public Map<Packagename, List<Set<ClassDescriptor>>> getSetsPerPackage() {
        return IntraPackageComponents.setsPerPackage(this.getComponents());
    }

    static Map<Packagename, List<Set<ClassDescriptor>>> setsPerPackage(List<Set<ClassDescriptor>> sets) {
        for (GroupBy set : ForEach.groupBy(sets)) {
            set.yield = ((ClassDescriptor)((Set)set.value).iterator().next()).getPackagename();
        }
        return (Map)ForEach.result();
    }

    private DirectedGraph<ClassDescriptor, Relation<ClassDescriptor>> calcGraph() {
        DefaultDirectedGraph graph = new DefaultDirectedGraph((EdgeFactory)new RelationFactory());
        for (ClassDescriptor descriptor : ClassDescriptor.getAll()) {
            graph.addVertex((Object)descriptor);
        }
        for (ClassDescriptor descriptor : ClassDescriptor.getAll()) {
            for (ClassDescriptor child : descriptor.getChildrenInSamePackage()) {
                graph.addEdge((Object)descriptor, (Object)child);
            }
        }
        return graph;
    }
}

