/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.core.filerelations.model;

import org.jgrapht.alg.StrongConnectivityInspector;
import org.projectusus.core.filerelations.model.ClassCycles;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.RelationGraph;
import org.projectusus.core.filerelations.model.Relations;

public class CrossPackageClassRelations
extends Relations<ClassDescriptor> {
    private ClassCycles classCycles;

    public CrossPackageClassRelations() {
        this.calcClassRelations();
        this.calcClassCycles();
    }

    private void calcClassRelations() {
        for (ClassDescriptor source : ClassDescriptor.getAll()) {
            for (ClassDescriptor target : source.getChildrenInOtherPackages()) {
                this.add(source, target);
            }
        }
    }

    private void calcClassCycles() {
        RelationGraph<ClassDescriptor> graph = new RelationGraph<ClassDescriptor>(this);
        StrongConnectivityInspector inspector = new StrongConnectivityInspector(graph);
        this.classCycles = new ClassCycles(inspector.stronglyConnectedSets());
    }

    public ClassCycles getCrossPackageClassCycles() {
        return this.classCycles;
    }
}

